/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bootstrap;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.testing.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import java.util.Map;
import javax.inject.Inject;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestBootstrap {
    @Test
    public void testRequiresExplicitBindings() throws Exception {
        Bootstrap bootstrap = new Bootstrap(new Module[0]);
        try {
            bootstrap.initialize().getInstance(Instance.class);
            Assert.fail((String)"should require explicit bindings");
        }
        catch (ConfigurationException e) {
            Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"Explicit bindings are required");
        }
    }

    @Test
    public void testDoesNotAllowCircularDependencies() throws Exception {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            binder.bind(InstanceA.class);
            binder.bind(InstanceB.class);
        }});
        try {
            bootstrap.initialize().getInstance(InstanceA.class);
            Assert.fail((String)"should not allow circular dependencies");
        }
        catch (ProvisionException e) {
            Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"circular dependencies are disabled");
        }
    }

    @Test(expectedExceptions={CreationException.class}, expectedExceptionsMessageRegExp=".*Configuration property 'not-supported' was not used.*")
    public void testStrictConfigDefault() {
        new Bootstrap(new Module[]{new ConfigModule()}).setRequiredConfigurationProperties((Map)ImmutableMap.of((Object)"not-supported", (Object)"1")).initialize();
    }

    @Test(expectedExceptions={CreationException.class}, expectedExceptionsMessageRegExp=".*Configuration property 'not-supported' was not used.*")
    public void testStrictConfig() {
        System.setProperty("bootstrap.strict-config", "true");
        new Bootstrap(new Module[]{new ConfigModule()}).setRequiredConfigurationProperties((Map)ImmutableMap.of((Object)"not-supported", (Object)"1")).initialize();
    }

    @Test
    public void testNoStrictConfig() {
        System.setProperty("bootstrap.strict-config", "false");
        ((LifeCycleManager)new Bootstrap(new Module[]{new ConfigModule()}).setRequiredConfigurationProperties((Map)ImmutableMap.of((Object)"not-supported", (Object)"1")).initialize().getInstance(LifeCycleManager.class)).stop();
    }

    private static class ConfigModule
    implements Module {
        private ConfigModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(TestingConfig.class);
        }
    }

    public static class TestingConfig {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public TestingConfig setValue(String value) {
            this.value = value;
            return this;
        }
    }

    public static class InstanceB {
        @Inject
        public InstanceB(InstanceA a) {
        }
    }

    public static class InstanceA {
        @Inject
        public InstanceA(InstanceB b) {
        }
    }

    public static class Instance {
    }
}

