/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bootstrap;

import com.facebook.airlift.bootstrap.AnInstance;
import com.facebook.airlift.bootstrap.AnotherInstance;
import com.facebook.airlift.bootstrap.BarInstance;
import com.facebook.airlift.bootstrap.BarProvider;
import com.facebook.airlift.bootstrap.DependentBoundInstance;
import com.facebook.airlift.bootstrap.DependentInstance;
import com.facebook.airlift.bootstrap.DependentInstanceImpl;
import com.facebook.airlift.bootstrap.DestroyExceptionInstance;
import com.facebook.airlift.bootstrap.ExecutedInstance;
import com.facebook.airlift.bootstrap.FooTestInstance;
import com.facebook.airlift.bootstrap.IllegalInstance;
import com.facebook.airlift.bootstrap.InstanceOne;
import com.facebook.airlift.bootstrap.InstanceThatRequiresStart;
import com.facebook.airlift.bootstrap.InstanceThatUsesInstanceThatRequiresStart;
import com.facebook.airlift.bootstrap.InstanceTwo;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.bootstrap.LifeCycleModule;
import com.facebook.airlift.bootstrap.LifeCycleStartException;
import com.facebook.airlift.bootstrap.LifeCycleStopException;
import com.facebook.airlift.bootstrap.PostConstructExceptionInstance;
import com.facebook.airlift.bootstrap.PostConstructOnly;
import com.facebook.airlift.bootstrap.PreDestroyOnly;
import com.facebook.airlift.bootstrap.SimpleBase;
import com.facebook.airlift.bootstrap.SimpleBaseImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestLifeCycleManager {
    private static final List<String> stateLog = new CopyOnWriteArrayList<String>();

    @BeforeMethod
    public void setup() {
        stateLog.clear();
    }

    static void note(String str) {
        stateLog.add(str);
    }

    @Test
    public void testImmediateStarts() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(InstanceThatRequiresStart.class).in(Scopes.SINGLETON);
            binder.bind(InstanceThatUsesInstanceThatRequiresStart.class).in(Scopes.SINGLETON);
        }});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"InstanceThatUsesInstanceThatRequiresStart:OK"));
    }

    @Test
    public void testPrivateModule() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.install((Module)new PrivateModule(){

            protected void configure() {
                this.binder().bind(SimpleBase.class).to(SimpleBaseImpl.class).in(Scopes.SINGLETON);
                this.binder().expose(SimpleBase.class);
            }
        })});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postSimpleBaseImpl"));
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postSimpleBaseImpl", (Object)"preSimpleBaseImpl"));
    }

    @Test
    public void testSubClassAnnotated() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.bind(SimpleBase.class).to(SimpleBaseImpl.class).in(Scopes.SINGLETON)});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postSimpleBaseImpl"));
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postSimpleBaseImpl", (Object)"preSimpleBaseImpl"));
    }

    @Test
    public void testExecuted() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.bind(ExecutedInstance.class).in(Scopes.SINGLETON)});
        ExecutedInstance instance = (ExecutedInstance)((Object)injector.getInstance(ExecutedInstance.class));
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        instance.waitForStart();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"Starting"));
        lifeCycleManager.stop();
        instance.waitForEnd();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"Starting", (Object)"Done"));
    }

    @Test
    public void testDeepDependency() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(AnInstance.class).in(Scopes.SINGLETON);
            binder.bind(AnotherInstance.class).in(Scopes.SINGLETON);
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
        }});
        injector.getInstance(AnotherInstance.class);
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postDependentInstance"));
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postDependentInstance", (Object)"preDependentInstance"));
    }

    @Test
    public void testIllegalMethods() {
        try {
            Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{binder -> binder.bind(IllegalInstance.class).in(Scopes.SINGLETON), new LifeCycleModule()});
            Assert.fail();
        }
        catch (CreationException creationException) {
            // empty catch block
        }
    }

    @Test
    public void testDuplicateMethodNames() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{binder -> binder.bind(FooTestInstance.class).in(Scopes.SINGLETON), new LifeCycleModule()});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"foo"));
    }

    @Test
    public void testJITInjection() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(AnInstance.class).in(Scopes.SINGLETON);
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
        }});
        injector.getInstance(AnInstance.class);
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postDependentInstance", (Object)"preDependentInstance"));
    }

    @Test
    public void testPreDestroySuppressedExceptionHandling() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
            binder.bind(DestroyExceptionInstance.class).in(Scopes.SINGLETON);
        }});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postDependentInstance"));
        try {
            lifeCycleManager.stopWithoutFailureLogging();
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (LifeCycleStopException e) {
            Assert.assertEquals((int)e.getSuppressed().length, (int)2, (String)"Expected two suppressed exceptions");
            Set suppressedMessages = Arrays.stream(e.getSuppressed()).map(Throwable::getMessage).collect(Collectors.toSet());
            Assert.assertEquals((Set)ImmutableSet.copyOf(suppressedMessages), (Set)ImmutableSet.of((Object)"preDestroyExceptionOne", (Object)"preDestroyExceptionTwo"));
        }
        Assert.assertEquals((Set)ImmutableSet.copyOf(stateLog), (Set)ImmutableSet.of((Object)"postDependentInstance", (Object)"preDestroyExceptionOne", (Object)"preDestroyExceptionTwo", (Object)"preDependentInstance"));
    }

    @Test
    public void testPreDestroyLoggingExceptionHandling() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
            binder.bind(DestroyExceptionInstance.class).in(Scopes.SINGLETON);
        }});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postDependentInstance"));
        try {
            lifeCycleManager.stop();
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (LifeCycleStopException e) {
            Assert.assertEquals((int)e.getSuppressed().length, (int)0, (String)"Suppressed exceptions list should be empty");
        }
        Assert.assertEquals((Set)ImmutableSet.copyOf(stateLog), (Set)ImmutableSet.of((Object)"postDependentInstance", (Object)"preDestroyExceptionOne", (Object)"preDestroyExceptionTwo", (Object)"preDependentInstance"));
    }

    @Test
    public void testPostConstructExceptionCallsPreDestroy() {
        try {
            Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.bind(PostConstructExceptionInstance.class).in(Scopes.SINGLETON)});
            Assert.fail((String)"Expected injector creation to fail with an exception");
        }
        catch (CreationException e) {
            Assert.assertEquals((Set)ImmutableSet.copyOf(stateLog), (Set)ImmutableSet.of((Object)"postConstructFailure", (Object)"preDestroyFailureAfterPostConstructFailureOne", (Object)"preDestroyFailureAfterPostConstructFailureTwo"));
            Assert.assertEquals(e.getCause().getClass(), LifeCycleStartException.class, (String)("Expected LifeCycleStartException to be thrown, found: " + e.getCause().getClass()));
            Assert.assertEquals((int)e.getCause().getSuppressed().length, (int)2, (String)"Expected two suppressed exceptions");
            Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)Arrays.stream(e.getCause().getSuppressed()).map(Throwable::getCause).map(Throwable::getMessage).collect(Collectors.toSet())), (Set)ImmutableSet.of((Object)"preDestroyFailureAfterPostConstructFailureOne", (Object)"preDestroyFailureAfterPostConstructFailureTwo"));
        }
    }

    @Test
    public void testNoPreDestroy() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(PostConstructOnly.class).in(Scopes.SINGLETON);
            binder.bind(PreDestroyOnly.class).in(Scopes.SINGLETON);
        }});
        injector.getInstance(PostConstructOnly.class);
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"makeMe"));
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"makeMe", (Object)"unmakeMe"));
    }

    @Test
    public void testModule() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> {
            binder.bind(DependentBoundInstance.class).to(DependentInstanceImpl.class).in(Scopes.SINGLETON);
            binder.bind(DependentInstance.class).in(Scopes.SINGLETON);
            binder.bind(InstanceOne.class).in(Scopes.SINGLETON);
            binder.bind(InstanceTwo.class).in(Scopes.SINGLETON);
        }});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        lifeCycleManager.stop();
        HashSet<String> stateLogSet = new HashSet<String>(stateLog);
        Assert.assertEquals(stateLogSet, (Set)Sets.newHashSet((Object[])new String[]{"postDependentBoundInstance", "postDependentInstance", "postMakeOne", "postMakeTwo", "preDestroyTwo", "preDestroyOne", "preDependentInstance", "preDependentBoundInstance"}));
    }

    @Test
    public void testProvider() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), binder -> binder.bind(BarInstance.class).toProvider(BarProvider.class).in(Scopes.SINGLETON)});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postBarProvider", (Object)"postBarInstance"));
        lifeCycleManager.stop();
        Assert.assertEquals(stateLog, (Collection)ImmutableList.of((Object)"postBarProvider", (Object)"postBarInstance", (Object)"preBarInstance", (Object)"preBarProvider"));
    }

    @Test
    public void testProviderReturningNull() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new LifeCycleModule(), new Module(){

            public void configure(Binder binder) {
            }

            @Provides
            public BarInstance createBar() {
                return null;
            }
        }});
        Assert.assertNull((Object)injector.getInstance(BarInstance.class));
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        lifeCycleManager.start();
        lifeCycleManager.stop();
        Assert.assertNull((Object)injector.getInstance(BarInstance.class));
    }
}

