/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bootstrap;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class LifeCycleMethods {
    private final Multimap<Class<? extends Annotation>, Method> methodMap = ArrayListMultimap.create();

    LifeCycleMethods(Class<?> clazz) {
        this.addLifeCycleMethods(clazz, new HashSet<String>(), new HashSet<String>());
    }

    boolean hasFor(Class<? extends Annotation> annotation) {
        Collection methods = this.methodMap.get(annotation);
        return methods != null && !methods.isEmpty();
    }

    Collection<Method> methodsFor(Class<? extends Annotation> annotation) {
        Collection methods = this.methodMap.get(annotation);
        return methods != null ? methods : new ArrayList();
    }

    private void addLifeCycleMethods(Class<?> clazz, Set<String> usedConstructNames, Set<String> usedDestroyNames) {
        if (clazz == null) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.isSynthetic() || method.isBridge()) continue;
            this.processMethod(method, PostConstruct.class, usedConstructNames);
            this.processMethod(method, PreDestroy.class, usedDestroyNames);
        }
        this.addLifeCycleMethods(clazz.getSuperclass(), usedConstructNames, usedDestroyNames);
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            this.addLifeCycleMethods((Class<?>)genericDeclaration, usedConstructNames, usedDestroyNames);
        }
    }

    private void processMethod(Method method, Class<? extends Annotation> annotationClass, Set<String> usedSet) {
        if (method.isAnnotationPresent(annotationClass) && !usedSet.contains(method.getName())) {
            if (method.getParameterTypes().length != 0) {
                throw new UnsupportedOperationException(String.format("@PostConstruct/@PreDestroy methods cannot have arguments: %s", method.getDeclaringClass().getName() + "." + method.getName() + "(...)"));
            }
            method.setAccessible(true);
            usedSet.add(method.getName());
            this.methodMap.put(annotationClass, (Object)method);
        }
    }
}

