/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.concurrent;

import com.facebook.airlift.concurrent.MoreFutures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkWhenAnyCompleteCancelOthers {
    @Param(value={"300", "1000"})
    private int futureCount;

    @Benchmark
    public void benchmark() throws Exception {
        Semaphore semaphore = new Semaphore(this.futureCount);
        ArrayList<SettableFuture> futures = new ArrayList<SettableFuture>();
        for (int i = 0; i < this.futureCount; ++i) {
            SettableFuture future = SettableFuture.create();
            future.addListener(() -> semaphore.release(1), MoreExecutors.directExecutor());
            futures.add(future);
        }
        ListenableFuture anyComplete = MoreFutures.whenAnyCompleteCancelOthers(futures);
        ((SettableFuture)futures.get(this.futureCount / 2)).set(null);
        semaphore.acquireUninterruptibly(this.futureCount);
        anyComplete.get();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkWhenAnyCompleteCancelOthers.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }
}

