/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.concurrent;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestBoundedExecutor {
    private ExecutorService executorService;

    @BeforeClass
    public void setUp() throws Exception {
        this.executorService = Executors.newCachedThreadPool();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.executorService.shutdownNow();
    }

    @Test
    public void testCounter() throws Exception {
        int i;
        int maxThreads = 1;
        BoundedExecutor boundedExecutor = new BoundedExecutor((Executor)this.executorService, maxThreads);
        int stageTasks = 100000;
        int totalTasks = stageTasks * 2;
        AtomicInteger counter = new AtomicInteger();
        CountDownLatch initializeLatch = new CountDownLatch(maxThreads);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch completeLatch = new CountDownLatch(totalTasks);
        for (i = 0; i < stageTasks; ++i) {
            boundedExecutor.execute(() -> {
                try {
                    initializeLatch.countDown();
                    Uninterruptibles.awaitUninterruptibly((CountDownLatch)startLatch);
                    int initialCount = counter.get();
                    counter.set(initialCount + 1);
                }
                finally {
                    completeLatch.countDown();
                }
            });
        }
        Assert.assertTrue((boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)initializeLatch, (long)1L, (TimeUnit)TimeUnit.MINUTES));
        startLatch.countDown();
        for (i = 0; i < stageTasks; ++i) {
            boundedExecutor.execute(() -> {
                try {
                    int initialCount = counter.get();
                    counter.set(initialCount + 1);
                }
                finally {
                    completeLatch.countDown();
                }
            });
        }
        Assert.assertTrue((boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)completeLatch, (long)1L, (TimeUnit)TimeUnit.MINUTES));
        Assert.assertEquals((int)counter.get(), (int)totalTasks);
    }

    @Test
    public void testSingleThreadBound() throws Exception {
        this.testBound(1, 100000);
    }

    @Test
    public void testDoubleThreadBound() throws Exception {
        this.testBound(2, 100000);
    }

    @Test
    public void testTripleThreadBound() throws Exception {
        this.testBound(3, 100000);
    }

    @Test
    public void testExecutorCorruptionDetection() throws Exception {
        AtomicBoolean reject = new AtomicBoolean();
        Executor executor = command -> {
            if (reject.get()) {
                throw new RejectedExecutionException();
            }
            this.executorService.execute(command);
        };
        BoundedExecutor boundedExecutor = new BoundedExecutor(executor, 1);
        reject.set(true);
        try {
            boundedExecutor.execute(() -> Assert.fail((String)"Should not be run"));
            Assert.fail((String)"Execute should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        reject.set(false);
        try {
            boundedExecutor.execute(() -> Assert.fail((String)"Should not be run"));
            Assert.fail((String)"Execute should still fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void testBound(int maxThreads, int stageTasks) {
        int i;
        BoundedExecutor boundedExecutor = new BoundedExecutor((Executor)this.executorService, maxThreads);
        int totalTasks = stageTasks * 2;
        AtomicInteger activeThreadCount = new AtomicInteger();
        CountDownLatch initializeLatch = new CountDownLatch(maxThreads);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch completeLatch = new CountDownLatch(totalTasks);
        AtomicBoolean failed = new AtomicBoolean();
        for (i = 0; i < stageTasks; ++i) {
            boundedExecutor.execute(() -> {
                try {
                    initializeLatch.countDown();
                    Uninterruptibles.awaitUninterruptibly((CountDownLatch)startLatch);
                    int count = activeThreadCount.incrementAndGet();
                    if (count < 1 || count > maxThreads) {
                        failed.set(true);
                    }
                    activeThreadCount.decrementAndGet();
                }
                finally {
                    completeLatch.countDown();
                }
            });
        }
        Assert.assertTrue((boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)initializeLatch, (long)1L, (TimeUnit)TimeUnit.MINUTES));
        startLatch.countDown();
        for (i = 0; i < stageTasks; ++i) {
            boundedExecutor.execute(() -> {
                try {
                    int count = activeThreadCount.incrementAndGet();
                    if (count < 1 || count > maxThreads) {
                        failed.set(true);
                    }
                    activeThreadCount.decrementAndGet();
                }
                finally {
                    completeLatch.countDown();
                }
            });
        }
        Assert.assertTrue((boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)completeLatch, (long)1L, (TimeUnit)TimeUnit.MINUTES));
        Assert.assertFalse((boolean)failed.get());
    }
}

