/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.concurrent;

import com.facebook.airlift.concurrent.ConcurrentScheduledExecutor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestConcurrentScheduledExecutor {
    private ConcurrentScheduledExecutor scheduler;

    @BeforeClass
    public void setUp() {
        this.scheduler = new ConcurrentScheduledExecutor(2, 1, "test-");
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.scheduler.shutdownNow();
        Assert.assertTrue((boolean)this.scheduler.awaitTermination(10L, TimeUnit.SECONDS));
        this.scheduler = null;
    }

    @Test
    public void testSubmit() throws Exception {
        AtomicInteger counter = new AtomicInteger();
        Future future = this.scheduler.submit(() -> counter.incrementAndGet());
        Assert.assertEquals(future.get(), (Object)1);
        Assert.assertEquals((int)counter.get(), (int)1);
    }

    @Test
    public void testSchedule() throws Exception {
        AtomicInteger counter = new AtomicInteger();
        ScheduledFuture scheduledFuture = this.scheduler.schedule(() -> counter.incrementAndGet(), 1L, TimeUnit.SECONDS);
        Assert.assertEquals(scheduledFuture.get(), (Object)1);
        Assert.assertEquals((int)counter.get(), (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAwaitTerminating() throws Exception {
        ConcurrentScheduledExecutor scheduler = new ConcurrentScheduledExecutor(2, 1, "test-");
        AtomicInteger counter = new AtomicInteger();
        try {
            for (int i = 0; i < 4; ++i) {
                scheduler.schedule(() -> counter.incrementAndGet(), (long)ThreadLocalRandom.current().nextInt(1000), TimeUnit.MILLISECONDS);
            }
        }
        finally {
            scheduler.shutdown();
            Assert.assertTrue((boolean)scheduler.awaitTermination(10L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)scheduler.isTerminated());
            scheduler = null;
            Assert.assertEquals((int)counter.get(), (int)4);
        }
    }
}

