/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.configuration;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.configuration.ConfigurationFactory;
import com.facebook.airlift.configuration.ConfigurationModule;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.airlift.configuration.LegacyConfig;
import com.facebook.airlift.configuration.Problems;
import com.facebook.airlift.configuration.TestMonitor;
import com.facebook.airlift.configuration.ValidationErrorModule;
import com.facebook.airlift.testing.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigurationFactoryTest {
    @Test
    public void testAnnotatedGettersThrows() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("string-value", "some value");
        properties.put("boolean-value", "true");
        TestMonitor monitor = new TestMonitor();
        try {
            ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(AnnotatedGetter.class));
            Assert.fail((String)"Expected an exception in object creation due to conflicting configuration");
        }
        catch (CreationException e) {
            monitor.assertNumberOfErrors(2);
            Assertions.assertContainsAllOf((String)e.getMessage(), (String[])new String[]{"not a valid setter", "getStringValue"});
            Assertions.assertContainsAllOf((String)e.getMessage(), (String[])new String[]{"not a valid setter", "isBooleanValue"});
        }
    }

    @Test
    public void testAnnotatedSetters() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("string-value", "some value");
        properties.put("boolean-value", "true");
        TestMonitor monitor = new TestMonitor();
        Injector injector = ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(AnnotatedSetter.class));
        AnnotatedSetter annotatedSetter = (AnnotatedSetter)injector.getInstance(AnnotatedSetter.class);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
        Assert.assertNotNull((Object)annotatedSetter);
        Assert.assertEquals((String)annotatedSetter.getStringValue(), (String)"some value");
        Assert.assertEquals((boolean)annotatedSetter.isBooleanValue(), (boolean)true);
    }

    @Test
    public void testConfigurationDespiteLegacyConfig() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("string-a", "this is a");
        properties.put("string-b", "this is b");
        TestMonitor monitor = new TestMonitor();
        Injector injector = ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(LegacyConfigPresent.class));
        LegacyConfigPresent legacyConfigPresent = (LegacyConfigPresent)injector.getInstance(LegacyConfigPresent.class);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
        Assert.assertNotNull((Object)legacyConfigPresent);
        Assert.assertEquals((String)legacyConfigPresent.getStringA(), (String)"this is a");
        Assert.assertEquals((String)legacyConfigPresent.getStringB(), (String)"this is b");
    }

    @Test
    public void testConfigurationThroughLegacyConfig() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("string-value", "this is a");
        properties.put("string-b", "this is b");
        TestMonitor monitor = new TestMonitor();
        Injector injector = ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(LegacyConfigPresent.class));
        LegacyConfigPresent legacyConfigPresent = (LegacyConfigPresent)injector.getInstance(LegacyConfigPresent.class);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(1);
        monitor.assertMatchingWarningRecorded("Configuration property 'string-value' has been replaced. Use 'string-a' instead.");
        Assert.assertNotNull((Object)legacyConfigPresent);
        Assert.assertEquals((String)legacyConfigPresent.getStringA(), (String)"this is a");
        Assert.assertEquals((String)legacyConfigPresent.getStringB(), (String)"this is b");
    }

    @Test
    public void testConfigurationWithPrefixThroughLegacyConfig() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("example.string-value", "this is a");
        properties.put("example.string-b", "this is b");
        TestMonitor monitor = new TestMonitor();
        Injector injector = ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(LegacyConfigPresent.class, "example"));
        LegacyConfigPresent legacyConfigPresent = (LegacyConfigPresent)injector.getInstance(LegacyConfigPresent.class);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(1);
        monitor.assertMatchingWarningRecorded("Configuration property 'example.string-value' has been replaced. Use 'example.string-a' instead.");
        Assert.assertNotNull((Object)legacyConfigPresent);
        Assert.assertEquals((String)legacyConfigPresent.getStringA(), (String)"this is a");
        Assert.assertEquals((String)legacyConfigPresent.getStringB(), (String)"this is b");
    }

    @Test
    public void testConfigurationWithRedundantLegacyConfigThrows() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("string-value", "this is a");
        properties.put("string-a", "this is a");
        properties.put("string-b", "this is b");
        TestMonitor monitor = new TestMonitor();
        try {
            ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(LegacyConfigPresent.class));
        }
        catch (CreationException e) {
            monitor.assertNumberOfErrors(1);
            monitor.assertNumberOfWarnings(1);
            monitor.assertMatchingWarningRecorded("string-value", "replaced", "Use 'string-a'");
            Assertions.assertContainsAllOf((String)e.getMessage(), (String[])new String[]{"string-value", "conflicts with property", "string-a"});
        }
    }

    @Test
    public void testConfigurationWithConflictingLegacyConfigThrows() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("string-value", "this is the old value");
        properties.put("string-a", "this is a");
        properties.put("string-b", "this is b");
        TestMonitor monitor = new TestMonitor();
        try {
            ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(LegacyConfigPresent.class));
            Assert.fail((String)"Expected an exception in object creation due to conflicting configuration");
        }
        catch (CreationException e) {
            monitor.assertNumberOfErrors(1);
            monitor.assertNumberOfWarnings(1);
            monitor.assertMatchingWarningRecorded("string-value", "replaced", "Use 'string-a'");
            Assertions.assertContainsAllOf((String)e.getMessage(), (String[])new String[]{"string-value", "conflicts with property", "string-a"});
        }
    }

    @Test
    public void testConfigurationDespiteDeprecatedConfig() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("string-b", "this is b");
        TestMonitor monitor = new TestMonitor();
        Injector injector = ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(DeprecatedConfigPresent.class));
        DeprecatedConfigPresent deprecatedConfigPresent = (DeprecatedConfigPresent)injector.getInstance(DeprecatedConfigPresent.class);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
        Assert.assertNotNull((Object)deprecatedConfigPresent);
        Assert.assertEquals((String)deprecatedConfigPresent.getStringA(), (String)"defaultA");
        Assert.assertEquals((String)deprecatedConfigPresent.getStringB(), (String)"this is b");
    }

    @Test
    public void testConfigurationThroughDeprecatedConfig() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("string-a", "this is a");
        properties.put("string-b", "this is b");
        TestMonitor monitor = new TestMonitor();
        Injector injector = ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(DeprecatedConfigPresent.class));
        DeprecatedConfigPresent deprecatedConfigPresent = (DeprecatedConfigPresent)injector.getInstance(DeprecatedConfigPresent.class);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(1);
        monitor.assertMatchingWarningRecorded("Configuration property 'string-a' is deprecated and should not be used");
        Assert.assertNotNull((Object)deprecatedConfigPresent);
        Assert.assertEquals((String)deprecatedConfigPresent.getStringA(), (String)"this is a");
        Assert.assertEquals((String)deprecatedConfigPresent.getStringB(), (String)"this is b");
    }

    @Test
    public void testConfigurationWithPrefixThroughDeprecatedConfig() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("example.string-a", "this is a");
        properties.put("example.string-b", "this is b");
        TestMonitor monitor = new TestMonitor();
        Injector injector = ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(DeprecatedConfigPresent.class, "example"));
        DeprecatedConfigPresent deprecatedConfigPresent = (DeprecatedConfigPresent)injector.getInstance(DeprecatedConfigPresent.class);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(1);
        monitor.assertMatchingWarningRecorded("Configuration property 'example.string-a' is deprecated and should not be used");
        Assert.assertNotNull((Object)deprecatedConfigPresent);
        Assert.assertEquals((String)deprecatedConfigPresent.getStringA(), (String)"this is a");
        Assert.assertEquals((String)deprecatedConfigPresent.getStringB(), (String)"this is b");
    }

    @Test
    public void testDefunctPropertyInConfigThrows() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("string-value", "this is a");
        properties.put("defunct-value", "this shouldn't work");
        TestMonitor monitor = new TestMonitor();
        try {
            ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(DefunctConfigPresent.class));
            Assert.fail((String)"Expected an exception in object creation due to use of defunct config");
        }
        catch (CreationException e) {
            monitor.assertNumberOfErrors(1);
            monitor.assertNumberOfWarnings(0);
            monitor.assertMatchingErrorRecorded("Defunct property 'defunct-value'", "cannot be configured");
        }
    }

    @Test
    public void testDefunctPropertyWithPrefixInConfigThrows() {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        properties.put("example.string-value", "this is a");
        properties.put("example.defunct-value", "this shouldn't work");
        TestMonitor monitor = new TestMonitor();
        try {
            ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(DefunctConfigPresent.class, "example"));
            Assert.fail((String)"Expected an exception in object creation due to use of defunct config");
        }
        catch (CreationException e) {
            monitor.assertNumberOfErrors(1);
            monitor.assertNumberOfWarnings(0);
            monitor.assertMatchingErrorRecorded("Defunct property 'example.defunct-value'", "cannot be configured");
        }
    }

    @Test
    public void testSuccessfulBeanValidation() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("string-value", "has a value");
        properties.put("int-value", "50");
        TestMonitor monitor = new TestMonitor();
        Injector injector = ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(BeanValidationClass.class));
        BeanValidationClass beanValidationClass = (BeanValidationClass)injector.getInstance(BeanValidationClass.class);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
        Assert.assertNotNull((Object)beanValidationClass);
        Assert.assertEquals((String)beanValidationClass.getStringValue(), (String)"has a value");
        Assert.assertEquals((int)beanValidationClass.getIntValue(), (int)50);
    }

    @Test
    public void testFailedBeanValidation() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("int-value", "5000");
        TestMonitor monitor = new TestMonitor();
        try {
            ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(BeanValidationClass.class));
            Assert.fail((String)"Expected an exception in object creation due to failed bean validation");
        }
        catch (CreationException e) {
            monitor.assertNumberOfErrors(2);
            monitor.assertNumberOfWarnings(0);
            monitor.assertMatchingErrorRecorded("Invalid configuration property int-value: must be less than or equal to 100", "BeanValidationClass");
            monitor.assertMatchingErrorRecorded("Invalid configuration property string-value: may not be null", "BeanValidationClass");
        }
    }

    @Test
    public void testFailedBeanValidationPrefix() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("example.int-value", "5000");
        TestMonitor monitor = new TestMonitor();
        try {
            ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(BeanValidationClass.class, "example"));
            Assert.fail((String)"Expected an exception in object creation due to failed bean validation");
        }
        catch (CreationException e) {
            monitor.assertNumberOfErrors(2);
            monitor.assertNumberOfWarnings(0);
            monitor.assertMatchingErrorRecorded("Invalid configuration property example.int-value: must be less than or equal to 100", "BeanValidationClass");
            monitor.assertMatchingErrorRecorded("Invalid configuration property example.string-value: may not be null", "BeanValidationClass");
        }
    }

    @Test
    public void testFailedCoercion() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("int-value", "abc %s xyz");
        TestMonitor monitor = new TestMonitor();
        try {
            ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(BeanValidationClass.class));
            Assert.fail((String)"Expected an exception in object creation due to failed coercion");
        }
        catch (CreationException e) {
            monitor.assertNumberOfErrors(1);
            monitor.assertNumberOfWarnings(0);
            monitor.assertMatchingErrorRecorded("Could not coerce value 'abc %s xyz' to int (property 'int-value')", "BeanValidationClass");
        }
    }

    @Test
    public void testFailedCoercionPrefix() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("example.int-value", "abc %s xyz");
        TestMonitor monitor = new TestMonitor();
        try {
            ConfigurationFactoryTest.createInjector(properties, monitor, binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(BeanValidationClass.class, "example"));
            Assert.fail((String)"Expected an exception in object creation due to failed coercion");
        }
        catch (CreationException e) {
            monitor.assertNumberOfErrors(1);
            monitor.assertNumberOfWarnings(0);
            monitor.assertMatchingErrorRecorded("Could not coerce value 'abc %s xyz' to int (property 'example.int-value')", "BeanValidationClass");
        }
    }

    private static Injector createInjector(Map<String, String> properties, TestMonitor monitor, Module module) {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(properties, null, (Problems.Monitor)monitor);
        configurationFactory.registerConfigurationClasses((Collection)ImmutableList.of((Object)module));
        List messages = configurationFactory.validateRegisteredConfigurationProvider();
        return Guice.createInjector((Module[])new Module[]{new ConfigurationModule(configurationFactory), module, new ValidationErrorModule(messages)});
    }

    public static class BeanValidationClass {
        @NotNull
        private String stringValue;
        private int myIntValue;

        public String getStringValue() {
            return this.stringValue;
        }

        @Config(value="string-value")
        public void setStringValue(String value) {
            this.stringValue = value;
        }

        @Min(value=1L)
        @Max(value=100L)
        public @Min(value=1L) @Max(value=100L) int getIntValue() {
            return this.myIntValue;
        }

        @Config(value="int-value")
        public void setIntValue(int value) {
            this.myIntValue = value;
        }
    }

    @DefunctConfig(value={"defunct-value"})
    public static class DefunctConfigPresent {
        private String stringValue;
        private boolean booleanValue;

        public String getStringValue() {
            return this.stringValue;
        }

        @Config(value="string-value")
        public void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }
    }

    public static class DeprecatedConfigPresent {
        private String stringA = "defaultA";
        private String stringB = "defaultB";

        @Deprecated
        public String getStringA() {
            return this.stringA;
        }

        @Deprecated
        @Config(value="string-a")
        public void setStringA(String stringValue) {
            this.stringA = stringValue;
        }

        public String getStringB() {
            return this.stringB;
        }

        @Config(value="string-b")
        public void setStringB(String stringValue) {
            this.stringB = stringValue;
        }
    }

    public static class LegacyConfigPresent {
        private String stringA = "defaultA";
        private String stringB = "defaultB";

        public String getStringA() {
            return this.stringA;
        }

        @Config(value="string-a")
        @LegacyConfig(value={"string-value"})
        public void setStringA(String stringValue) {
            this.stringA = stringValue;
        }

        public String getStringB() {
            return this.stringB;
        }

        @Config(value="string-b")
        public void setStringB(String stringValue) {
            this.stringB = stringValue;
        }
    }

    public static class AnnotatedSetter {
        private String stringValue;
        private boolean booleanValue;

        public String getStringValue() {
            return this.stringValue;
        }

        @Config(value="string-value")
        public void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public boolean isBooleanValue() {
            return this.booleanValue;
        }

        @Config(value="boolean-value")
        public void setBooleanValue(boolean booleanValue) {
            this.booleanValue = booleanValue;
        }
    }

    public static class AnnotatedGetter {
        private String stringValue;
        private boolean booleanValue;

        @Config(value="string-value")
        public String getStringValue() {
            return this.stringValue;
        }

        public void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Config(value="boolean-value")
        public boolean isBooleanValue() {
            return this.booleanValue;
        }

        public void setBooleanValue(boolean booleanValue) {
            this.booleanValue = booleanValue;
        }
    }
}

