/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.configuration;

import com.facebook.airlift.configuration.Problems;
import com.facebook.airlift.testing.Assertions;
import com.google.inject.ConfigurationException;
import com.google.inject.spi.Message;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProblemsTest {
    @Test
    public void TestOneError() {
        Problems problems = new Problems();
        problems.addError("message %d", new Object[]{1});
        Message[] errors = problems.getErrors().toArray(new Message[0]);
        Assert.assertEquals((int)errors.length, (int)1);
        Assertions.assertContainsAllOf((String)errors[0].toString(), (String[])new String[]{"Error", "message 1"});
        Assert.assertEquals((int)problems.getWarnings().size(), (int)0, (String)"Found unexpected warnings in problem object");
        try {
            problems.throwIfHasErrors();
            Assert.fail((String)"Expected exception from problems object");
        }
        catch (ConfigurationException e) {
            Assertions.assertContainsAllOf((String)e.getMessage(), (String[])new String[]{"message 1"});
        }
    }

    @Test
    public void TestTwoErrors() {
        Problems problems = new Problems();
        problems.addError("message %d", new Object[]{1});
        problems.addError("message %d", new Object[]{2});
        Message[] errors = problems.getErrors().toArray(new Message[0]);
        Assert.assertEquals((int)errors.length, (int)2);
        Assertions.assertContainsAllOf((String)errors[0].toString(), (String[])new String[]{"Error", "message 1"});
        Assertions.assertContainsAllOf((String)errors[1].toString(), (String[])new String[]{"Error", "message 2"});
        Assert.assertEquals((int)problems.getWarnings().size(), (int)0, (String)"Found unexpected warnings in problem object");
        try {
            problems.throwIfHasErrors();
            Assert.fail((String)"Expected exception from problems object");
        }
        catch (ConfigurationException e) {
            Assertions.assertContainsAllOf((String)e.getMessage(), (String[])new String[]{"message 1", "message 2"});
        }
    }

    @Test
    public void TestFormatError() {
        Problems problems = new Problems();
        problems.addError("message %d", new Object[]{"NaN"});
        Message[] errors = problems.getErrors().toArray(new Message[0]);
        Assert.assertEquals((int)errors.length, (int)1);
        Assertions.assertContainsAllOf((String)errors[0].toString(), (String[])new String[]{"Error", "message %d", "NaN", "IllegalFormatConversionException"});
        Assert.assertEquals((int)problems.getWarnings().size(), (int)0, (String)"Found unexpected warnings in problem object");
        try {
            problems.throwIfHasErrors();
            Assert.fail((String)"Expected exception from problems object");
        }
        catch (ConfigurationException e) {
            Assertions.assertContains((String)e.getMessage(), (String)"message %d [NaN]");
        }
    }

    @Test
    public void TestOneWarning() {
        Problems problems = new Problems();
        problems.addWarning("message %d", new Object[]{1});
        Assert.assertEquals((int)problems.getErrors().size(), (int)0, (String)"Found unexpected errors in problem object");
        Message[] warnings = problems.getWarnings().toArray(new Message[0]);
        Assert.assertEquals((int)warnings.length, (int)1);
        Assertions.assertContainsAllOf((String)warnings[0].toString(), (String[])new String[]{"Warning", "message 1"});
        try {
            problems.throwIfHasErrors();
        }
        catch (ConfigurationException cause) {
            Assert.fail((String)"Didn't expect problems object to throw", (Throwable)cause);
        }
    }

    @Test
    public void TestTwoWarnings() {
        Problems problems = new Problems();
        problems.addWarning("message %d", new Object[]{1});
        problems.addWarning("message %d", new Object[]{2});
        Assert.assertEquals((int)problems.getErrors().size(), (int)0, (String)"Found unexpected errors in problem object");
        Message[] warnings = problems.getWarnings().toArray(new Message[0]);
        Assert.assertEquals((int)warnings.length, (int)2);
        Assertions.assertContainsAllOf((String)warnings[0].toString(), (String[])new String[]{"Warning", "message 1"});
        Assertions.assertContainsAllOf((String)warnings[1].toString(), (String[])new String[]{"Warning", "message 2"});
        try {
            problems.throwIfHasErrors();
        }
        catch (ConfigurationException cause) {
            Assert.fail((String)"Didn't expect problems object to throw", (Throwable)cause);
        }
    }

    @Test
    public void TestFormatWarning() {
        Problems problems = new Problems();
        problems.addWarning("message %d", new Object[]{"NaN"});
        Assert.assertEquals((int)problems.getErrors().size(), (int)0, (String)"Found unexpected errors in problem object");
        Message[] warnings = problems.getWarnings().toArray(new Message[0]);
        Assert.assertEquals((int)warnings.length, (int)1);
        Assertions.assertContainsAllOf((String)warnings[0].toString(), (String[])new String[]{"Warning", "message %d", "NaN", "IllegalFormatConversionException"});
        try {
            problems.throwIfHasErrors();
        }
        catch (ConfigurationException cause) {
            Assert.fail((String)"Didn't expect problems object to throw", (Throwable)cause);
        }
    }

    @Test
    public void TestErrorsAndWarnings() {
        Problems problems = new Problems();
        problems.addError("message e%d", new Object[]{1});
        problems.addError("message e%d", new Object[]{2});
        problems.addWarning("message w%d", new Object[]{1});
        problems.addWarning("message w%d", new Object[]{2});
        problems.addWarning("message w%d", new Object[]{3});
        Message[] errors = problems.getErrors().toArray(new Message[0]);
        Assert.assertEquals((int)errors.length, (int)2);
        Assertions.assertContainsAllOf((String)errors[0].toString(), (String[])new String[]{"Error", "message e1"});
        Assertions.assertContainsAllOf((String)errors[1].toString(), (String[])new String[]{"Error", "message e2"});
        Message[] warnings = problems.getWarnings().toArray(new Message[0]);
        Assert.assertEquals((int)warnings.length, (int)3);
        Assertions.assertContainsAllOf((String)warnings[0].toString(), (String[])new String[]{"Warning", "message w1"});
        Assertions.assertContainsAllOf((String)warnings[1].toString(), (String[])new String[]{"Warning", "message w2"});
        Assertions.assertContainsAllOf((String)warnings[2].toString(), (String[])new String[]{"Warning", "message w3"});
        try {
            problems.throwIfHasErrors();
            Assert.fail((String)"Expected exception from problems object");
        }
        catch (ConfigurationException e) {
            Assertions.assertContainsAllOf((String)e.getMessage(), (String[])new String[]{"message e1", "message e2", "message w1", "message w2", "message w3"});
        }
    }

    @Test
    public void TestMonitor() {
        SimpleMonitor monitor = new SimpleMonitor();
        Problems problems = new Problems((Problems.Monitor)monitor);
        problems.addError("1", new Object[0]);
        problems.addWarning("1", new Object[0]);
        problems.addWarning("2", new Object[0]);
        problems.addWarning("3", new Object[0]);
        problems.addError("2", new Object[0]);
        Assertions.assertContains((String)monitor.getResult(), (String)"E-Error: 1, W-Warning: 1, W-Warning: 2, W-Warning: 3, E-Error: 2");
    }

    private static class SimpleMonitor
    implements Problems.Monitor {
        private String result = "";

        private SimpleMonitor() {
        }

        public void onError(Message error) {
            this.result = this.result + "E-" + error.getMessage() + ", ";
        }

        public void onWarning(Message warning) {
            this.result = this.result + "W-" + warning.getMessage() + ", ";
        }

        public String getResult() {
            return this.result;
        }
    }
}

