/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.configuration;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.Config1;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.configuration.ConfigDefaults;
import com.facebook.airlift.configuration.ConfigWithNoAnnotations;
import com.facebook.airlift.configuration.ConfigurationBinding;
import com.facebook.airlift.configuration.ConfigurationFactory;
import com.facebook.airlift.configuration.ConfigurationModule;
import com.facebook.airlift.configuration.MyEnum;
import com.facebook.airlift.configuration.ValidationErrorModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Qualifier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestConfig {
    private final Map<String, String> properties = ImmutableMap.builder().put((Object)"stringOption", (Object)"a string").put((Object)"booleanOption", (Object)"true").put((Object)"boxedBooleanOption", (Object)"true").put((Object)"byteOption", (Object)Byte.toString((byte)127)).put((Object)"boxedByteOption", (Object)Byte.toString((byte)127)).put((Object)"shortOption", (Object)Short.toString((short)Short.MAX_VALUE)).put((Object)"boxedShortOption", (Object)Short.toString((short)Short.MAX_VALUE)).put((Object)"integerOption", (Object)Integer.toString(Integer.MAX_VALUE)).put((Object)"boxedIntegerOption", (Object)Integer.toString(Integer.MAX_VALUE)).put((Object)"longOption", (Object)Long.toString(Long.MAX_VALUE)).put((Object)"boxedLongOption", (Object)Long.toString(Long.MAX_VALUE)).put((Object)"floatOption", (Object)Float.toString(Float.MAX_VALUE)).put((Object)"boxedFloatOption", (Object)Float.toString(Float.MAX_VALUE)).put((Object)"doubleOption", (Object)Double.toString(Double.MAX_VALUE)).put((Object)"boxedDoubleOption", (Object)Double.toString(Double.MAX_VALUE)).put((Object)"myEnumOption", (Object)"FOO").put((Object)"myEnumSecondOption", (Object)"bar").put((Object)"valueClassOption", (Object)"a value class").build();

    @Test
    public void testConfig() {
        Injector injector = TestConfig.createInjector(this.properties, TestConfig.createModule(Key.get(Config1.class), Config1.class, null, new ConfigDefaults[0]));
        TestConfig.verifyConfig((Config1)injector.getInstance(Config1.class));
    }

    @Test
    public void testConfigWithAnnotationType() {
        Injector injector = TestConfig.createInjector(this.properties, TestConfig.createModule(Key.get(Config1.class, MyAnnotation.class), Config1.class, null, new ConfigDefaults[0]));
        TestConfig.verifyConfig((Config1)injector.getInstance(Key.get(Config1.class, MyAnnotation.class)));
    }

    @Test
    public void testConfigWithAnnotationObject() {
        Injector injector = TestConfig.createInjector(this.properties, TestConfig.createModule(Key.get(Config1.class, (Annotation)Names.named((String)"boo")), Config1.class, null, new ConfigDefaults[0]));
        TestConfig.verifyConfig((Config1)injector.getInstance(Key.get(Config1.class, (Annotation)Names.named((String)"boo"))));
    }

    @Test
    public void testPrefixConfigTypes() {
        Injector injector = TestConfig.createInjector(TestConfig.prefix("prefix", this.properties), TestConfig.createModule(Key.get(Config1.class), Config1.class, "prefix", new ConfigDefaults[0]));
        TestConfig.verifyConfig((Config1)injector.getInstance(Config1.class));
    }

    @Test
    public void testConfigDefaults() {
        Injector injector = TestConfig.createInjector((Map<String, String>)ImmutableMap.of(), TestConfig.createModule(Key.get(Config1.class), Config1.class, null, new StringOptionDefaults("default string")));
        Config1 config = (Config1)injector.getInstance(Config1.class);
        Assert.assertEquals((String)"default string", (String)config.getStringOption());
    }

    @Test
    public void testConfigDefaultsWithAnnotationType() {
        Injector injector = TestConfig.createInjector((Map<String, String>)ImmutableMap.of(), TestConfig.createModule(Key.get(Config1.class, MyAnnotation.class), Config1.class, null, new StringOptionDefaults("default string")));
        Config1 config = (Config1)injector.getInstance(Key.get(Config1.class, MyAnnotation.class));
        Assert.assertEquals((String)"default string", (String)config.getStringOption());
    }

    @Test
    public void testConfigDefaultsWithAnnotationObject() {
        Injector injector = TestConfig.createInjector((Map<String, String>)ImmutableMap.of(), TestConfig.createModule(Key.get(Config1.class, (Annotation)Names.named((String)"boo")), Config1.class, null, new StringOptionDefaults("default string")));
        Config1 config = (Config1)injector.getInstance(Key.get(Config1.class, (Annotation)Names.named((String)"boo")));
        Assert.assertEquals((String)"default string", (String)config.getStringOption());
    }

    @Test
    public void testConfigDefaultsOverride() {
        Injector injector = TestConfig.createInjector((Map<String, String>)ImmutableMap.of(), TestConfig.createModule(Key.get(Config1.class), Config1.class, null, new StringOptionDefaults("default string"), new StringOptionDefaults("another default string"), new StringOptionDefaults("final default string")));
        Config1 config = (Config1)injector.getInstance(Config1.class);
        Assert.assertEquals((String)"final default string", (String)config.getStringOption());
    }

    @Test
    public void testPropertiesOverrideDefaults() {
        Injector injector = TestConfig.createInjector(this.properties, TestConfig.createModule(Key.get(Config1.class), Config1.class, null, new StringOptionDefaults("default string"), new StringOptionDefaults("another default string"), new StringOptionDefaults("final default string")));
        TestConfig.verifyConfig((Config1)injector.getInstance(Config1.class));
    }

    private static void verifyConfig(Config1 config) {
        Assert.assertEquals((String)"a string", (String)config.getStringOption());
        Assert.assertEquals((boolean)true, (boolean)config.getBooleanOption());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)config.getBoxedBooleanOption());
        Assert.assertEquals((byte)127, (byte)config.getByteOption());
        Assert.assertEquals((Object)127, (Object)config.getBoxedByteOption());
        Assert.assertEquals((short)Short.MAX_VALUE, (short)config.getShortOption());
        Assert.assertEquals((Object)Short.MAX_VALUE, (Object)config.getBoxedShortOption());
        Assert.assertEquals((int)Integer.MAX_VALUE, (int)config.getIntegerOption());
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)config.getBoxedIntegerOption());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)config.getLongOption());
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)config.getBoxedLongOption());
        Assert.assertEquals((float)Float.MAX_VALUE, (float)config.getFloatOption(), (float)0.0f);
        Assert.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)config.getBoxedFloatOption());
        Assert.assertEquals((double)Double.MAX_VALUE, (double)config.getDoubleOption(), (double)0.0);
        Assert.assertEquals((Object)Double.MAX_VALUE, (Object)config.getBoxedDoubleOption());
        Assert.assertEquals((Object)((Object)MyEnum.FOO), (Object)((Object)config.getMyEnumOption()));
        Assert.assertEquals((Object)((Object)MyEnum.BAR), (Object)((Object)config.getMyEnumSecondOption()));
        Assert.assertEquals((String)config.getValueClassOption().getValue(), (String)"a value class");
    }

    @Test
    public void testDetectsNoConfigAnnotations() {
        try {
            Injector injector = TestConfig.createInjector(Collections.emptyMap(), TestConfig.createModule(Key.get(ConfigWithNoAnnotations.class), ConfigWithNoAnnotations.class, null, new ConfigDefaults[0]));
            injector.getInstance(ConfigWithNoAnnotations.class);
            Assert.fail((String)"Expected exception due to missing @Config annotations");
        }
        catch (CreationException creationException) {
            // empty catch block
        }
    }

    @Test
    public void testConfigGlobalDefaults() throws Exception {
        int globalDefaultValue = 1;
        int defaultValue = 2;
        int customValue = 3;
        Module module = binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfigGlobalDefaults(Config1.class, config -> {
                config.setByteOption((byte)globalDefaultValue);
                config.setIntegerOption(globalDefaultValue);
                config.setLongOption(globalDefaultValue);
            });
            ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(Config1.class, MyAnnotation.class, config -> {
                config.setIntegerOption(defaultValue);
                config.setLongOption(defaultValue);
            });
            ConfigBinder.configBinder((Binder)binder).bindConfig(Config1.class, MyAnnotation.class);
        };
        Injector injector = TestConfig.createInjector((Map<String, String>)ImmutableMap.of((Object)"longOption", (Object)("" + customValue)), module);
        Config1 config = (Config1)injector.getInstance(Key.get(Config1.class, MyAnnotation.class));
        Assert.assertEquals((int)config.getByteOption(), (int)globalDefaultValue);
        Assert.assertEquals((int)config.getIntegerOption(), (int)defaultValue);
        Assert.assertEquals((long)config.getLongOption(), (long)customValue);
    }

    @Test
    public void testConfigurationBindingListener() {
        ArrayList seenBindings = new ArrayList();
        Module module = binder -> {
            ConfigBinder configBinder = ConfigBinder.configBinder((Binder)binder);
            configBinder.bindConfig(AnotherConfig.class);
            configBinder.bindConfigurationBindingListener((configurationBinding, callbackConfigBinder) -> {
                seenBindings.add(configurationBinding);
                callbackConfigBinder.bindConfig(Config1.class);
                callbackConfigBinder.bindConfig(Config1.class, MyAnnotation.class);
            });
        };
        Injector injector = TestConfig.createInjector(this.properties, module);
        TestConfig.verifyConfig((Config1)injector.getInstance(Config1.class));
        TestConfig.verifyConfig((Config1)injector.getInstance(Key.get(Config1.class, MyAnnotation.class)));
        Assert.assertEquals((int)seenBindings.size(), (int)3);
        Assert.assertEquals((Set)ImmutableSet.copyOf(seenBindings), (Set)ImmutableSet.of((Object)new ConfigurationBinding(Key.get(Config1.class), Config1.class, Optional.empty()), (Object)new ConfigurationBinding(Key.get(Config1.class, MyAnnotation.class), Config1.class, Optional.empty()), (Object)new ConfigurationBinding(Key.get(AnotherConfig.class), AnotherConfig.class, Optional.empty())));
    }

    private static Injector createInjector(Map<String, String> properties, Module module) {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(properties);
        configurationFactory.registerConfigurationClasses((Collection)ImmutableList.of((Object)module));
        List messages = configurationFactory.validateRegisteredConfigurationProvider();
        return Guice.createInjector((Module[])new Module[]{new ConfigurationModule(configurationFactory), module, new ValidationErrorModule(messages), Binder::requireExplicitBindings});
    }

    @SafeVarargs
    private static <T> Module createModule(Key<T> key, Class<T> configClass, String prefix, ConfigDefaults<T> ... configDefaults) {
        Module module = binder -> {
            ConfigBinder configBinder = ConfigBinder.configBinder((Binder)binder);
            configBinder.bindConfig(key, configClass, prefix);
            for (ConfigDefaults configDefault : configDefaults) {
                configBinder.bindConfigDefaults(key, configDefault);
            }
        };
        return module;
    }

    private static Map<String, String> prefix(String prefix, Map<String, String> properties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            builder.put((Object)(prefix + "." + entry.getKey()), (Object)entry.getValue());
        }
        return builder.build();
    }

    public static class AnotherConfig {
        private String stringOption;

        public String getStringOption() {
            return this.stringOption;
        }

        @Config(value="stringOption")
        public AnotherConfig setStringOption(String stringOption) {
            this.stringOption = stringOption;
            return this;
        }
    }

    private static class StringOptionDefaults
    implements ConfigDefaults<Config1> {
        private final String stringOptionDefault;

        private StringOptionDefaults(String stringOptionDefault) {
            this.stringOptionDefault = stringOptionDefault;
        }

        public void setDefaults(Config1 config) {
            config.setStringOption(this.stringOptionDefault);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Qualifier
    public static @interface MyAnnotation {
    }
}

