/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.configuration;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.configuration.ConfigurationFactory;
import com.facebook.airlift.configuration.ConfigurationInspector;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestConfigurationInspector {
    @Test
    public void testDefaultValue() {
        List defaultString = (List)this.getConfigRecord().getAttributes().stream().map(ConfigurationInspector.ConfigAttribute::getDefaultValue).collect(ImmutableList.toImmutableList());
        Assert.assertEquals((Collection)defaultString, (Collection)ImmutableList.of((Object)"----"));
    }

    @Test
    public void testCurrentValue() {
        List currentString = (List)this.getConfigRecord().getAttributes().stream().map(ConfigurationInspector.ConfigAttribute::getCurrentValue).collect(ImmutableList.toImmutableList());
        Assert.assertEquals((Collection)currentString, (Collection)ImmutableList.of((Object)"string"));
    }

    private ConfigurationInspector.ConfigRecord<?> getConfigRecord() {
        ImmutableMap properties = ImmutableMap.of((Object)"stringValue", (Object)"string");
        ConfigurationFactory configurationFactory = new ConfigurationFactory((Map)properties);
        configurationFactory.registerConfigurationClasses(binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(ConfigWithOptionalValue.class));
        return (ConfigurationInspector.ConfigRecord)Iterables.getOnlyElement((Iterable)new ConfigurationInspector().inspect(configurationFactory));
    }

    public static class ConfigWithOptionalValue {
        private String stringValue;

        @Config(value="stringValue")
        public ConfigWithOptionalValue setStringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public Optional<String> getStringValue() {
            return Optional.ofNullable(this.stringValue);
        }
    }
}

