/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.configuration;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.ConfigSecuritySensitive;
import com.facebook.airlift.configuration.ConfigurationMetadata;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.airlift.configuration.LegacyConfig;
import com.facebook.airlift.configuration.Problems;
import com.facebook.airlift.configuration.TestMonitor;
import com.facebook.airlift.testing.EquivalenceTester;
import com.google.common.collect.ImmutableSet;
import com.google.inject.ConfigurationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigurationMetadataTest {
    @Test
    public void testEquivalence() {
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)ConfigurationMetadata.getConfigurationMetadata(SetterSubConfigClass.class), new Object[]{ConfigurationMetadata.getConfigurationMetadata(SetterSubConfigClass.class)}).addEquivalentGroup((Object)ConfigurationMetadata.getConfigurationMetadata(SetterConfigClass.class), new Object[]{ConfigurationMetadata.getConfigurationMetadata(SetterConfigClass.class)}).check();
        EquivalenceTester.equivalenceTester().addEquivalentGroup(ConfigurationMetadata.getConfigurationMetadata(SetterSubConfigClass.class).getAttributes().get("Value"), new Object[]{ConfigurationMetadata.getConfigurationMetadata(SetterSubConfigClass.class).getAttributes().get("Value")}).addEquivalentGroup(ConfigurationMetadata.getConfigurationMetadata(SetterConfigClass.class).getAttributes().get("Value"), new Object[]{ConfigurationMetadata.getConfigurationMetadata(SetterConfigClass.class).getAttributes().get("Value")}).check();
    }

    @Test
    public void testSetterConfigClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(SetterConfigClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, SetterConfigClass.class, "description", false, expectedAttributes);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
    }

    @Test
    public void testSetterSensitiveClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(SetterSensitiveClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, SetterSensitiveClass.class, "description", true, expectedAttributes);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
    }

    @Test
    public void testSubSetterConfigClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(SetterSubConfigClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, SetterSubConfigClass.class, "description", false, expectedAttributes);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
    }

    @Test
    public void testSetterInterfaceImpl() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(SetterInterfaceImpl.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, SetterInterfaceImpl.class, "description", false, expectedAttributes);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
    }

    @Test
    public void testSetterNoGetterConfigClassThrows() throws Exception {
        TestMonitor monitor = new TestMonitor();
        try {
            ConfigurationMetadata metadata = ConfigurationMetadata.getValidConfigurationMetadata(SetterNoGetterConfigClass.class, (Problems.Monitor)monitor);
            Assert.fail((String)"Expected ConfigurationException");
        }
        catch (ConfigurationException e) {
            monitor.assertNumberOfErrors(1);
            monitor.assertNumberOfWarnings(0);
            monitor.assertMatchingErrorRecorded("No getter");
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNull() {
        ConfigurationMetadata.getConfigurationMetadata(null);
    }

    @Test
    public void testAbstractClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(AbstractClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, AbstractClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("abstract", AbstractClass.class.getName());
    }

    @Test
    public void testGetValidAbstractClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        try {
            ConfigurationMetadata.getValidConfigurationMetadata(AbstractClass.class, (Problems.Monitor)monitor);
            Assert.fail((String)"Expected ConfigurationException");
        }
        catch (ConfigurationException e) {
            monitor.assertNumberOfErrors(1);
            monitor.assertNumberOfWarnings(0);
            monitor.assertMatchingErrorRecorded("abstract", AbstractClass.class.getName());
        }
    }

    @Test
    public void testNotPublicClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(NotPublicClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, NotPublicClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("not public", NotPublicClass.class.getName());
    }

    @Test
    public void testNotPublicConstructorClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(NotPublicConstructorClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, NotPublicConstructorClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("not public", metadata.getConfigClass().getName() + "()");
    }

    @Test
    public void testNoNoArgConstructorClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(NoNoArgConstructorClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, NoNoArgConstructorClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("no-arg constructor", NoNoArgConstructorClass.class.getName());
    }

    @Test
    public void testNoConfigMethodsClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(NoConfigMethodsClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, NoConfigMethodsClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("does not have any @Config annotations", NoConfigMethodsClass.class.getName());
    }

    @Test
    public void testGetterAndSetterAnnotatedClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(GetterAndSetterAnnotatedClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, GetterAndSetterAnnotatedClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded(GetterAndSetterAnnotatedClass.class.getName());
    }

    @Test
    public void testEmptyPropertyNameClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(EmptyPropertyNameClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, EmptyPropertyNameClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("empty value", "setValue");
    }

    @Test
    public void testNotPublicAttributeClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(NotPublicAttributeClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, NotPublicAttributeClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("No getter", "unusable", "getValue", "setValue");
    }

    @Test
    public void testStaticAttributeClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(StaticAttributeClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, StaticAttributeClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded(StaticAttributeClass.class.getName(), "setValue", "is static");
    }

    @Test
    public void testGetterWithParameterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(GetterWithParameterClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, GetterWithParameterClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("No getter", "unusable", "getValue", "setValue");
    }

    @Test
    public void testGetterNoReturnClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(GetterNoReturnClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, GetterNoReturnClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("No getter", "unusable", "getValue", "setValue");
    }

    @Test
    public void testGetterNoSetterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(GetterNoSetterClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, GetterNoSetterClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("is not a valid setter", GetterNoSetterClass.class.getName(), "getValue");
    }

    @Test
    public void testGetterMultipleSettersClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(GetterMultipleSettersClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, GetterMultipleSettersClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
    }

    @Test
    public void testGetterPrivateSetterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(GetterPrivateSetterClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, GetterPrivateSetterClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@Config method", "setValue", "is not public");
    }

    @Test
    public void testIsMethodWithParameterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(IsMethodWithParameterClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, IsMethodWithParameterClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("No getter", "unusable", "isValue", "setValue");
    }

    @Test
    public void testIsMethodNoReturnClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(IsMethodNoReturnClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, IsMethodNoReturnClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("No getter", "setValue");
    }

    @Test
    public void testIsMethodNoSetterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(IsMethodNoSetterClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, IsMethodNoSetterClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded(IsMethodNoSetterClass.class.getName(), "isValue", "is not a valid setter");
    }

    @Test
    public void testIsMethodMultipleSettersClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(IsMethodMultipleSettersClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, IsMethodMultipleSettersClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
    }

    @Test
    public void testIsMethodPrivateSetterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(IsMethodPrivateSetterClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, IsMethodPrivateSetterClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@Config method", IsMethodPrivateSetterClass.class.getName(), "setValue", "is not public");
    }

    @Test
    public void testSetterWithNoParameterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(SetterWithNoParameterClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, SetterWithNoParameterClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("does not have exactly one parameter", SetterWithNoParameterClass.class.getName(), "setValue");
    }

    @Test
    public void testNotJavaBeanClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(NotJavaBeanClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, NotJavaBeanClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("not a valid setter", "putValue");
    }

    @Test
    public void testMultipleAnnotatedSettersClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(MultipleAnnotatedSettersClass.class, (Problems.Monitor)monitor);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("Multiple methods are annotated", "Value");
    }

    @Test
    public void testCurrentAndLegacyConfigOnGetterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(CurrentAndLegacyConfigOnGetterClass.class, (Problems.Monitor)monitor);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("not a valid setter", "getValue");
    }

    @Test
    public void testCurrentAndLegacyConfigOnSetterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(CurrentAndLegacyConfigOnSetterClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value", (Object)"replacedValue"));
        this.verifyMetaData(metadata, CurrentAndLegacyConfigOnSetterClass.class, "description", false, expectedAttributes);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
    }

    @Test
    public void testCurrentConfigWithReplacedByClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(CurrentConfigWithReplacedByClass.class, (Problems.Monitor)monitor);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@Config method", "setValue", "claiming to be replaced by", "'other-name'");
    }

    @Test
    public void testLegacyConfigOnGetterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(LegacyConfigOnGetterClass.class, (Problems.Monitor)monitor);
        monitor.assertNumberOfErrors(2);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("not a valid setter", "getValue");
        monitor.assertMatchingErrorRecorded("LegacyConfig", "getValue", "not associated with any valid @Config");
    }

    @Test
    public void testLegacyConfigOnSetterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(LegacyConfigOnSetterClass.class, (Problems.Monitor)monitor);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("LegacyConfig", "setValue", "not associated with any valid @Config");
    }

    @Test
    public void testLegacyConfigOnDeprecatedSetterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(LegacyConfigOnDeprecatedSetterClass.class, (Problems.Monitor)monitor);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
    }

    @Test
    public void testLegacyConfigOnNonDeprecatedSetterClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(LegacyConfigOnNonDeprecatedSetterClass.class, (Problems.Monitor)monitor);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(1);
        monitor.assertMatchingWarningRecorded("Replaced @LegacyConfig method", "setValue(int)", "should be @Deprecated");
    }

    @Test
    public void testMultipleLegacyConfigClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(MultipleLegacyConfigClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"legacy1", (Object)"legacy2", (Object)"value"));
        this.verifyMetaData(metadata, MultipleLegacyConfigClass.class, "description", false, expectedAttributes);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
    }

    @Test
    public void testEmptyStringLegacyConfigClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(EmptyStringLegacyConfigClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, EmptyStringLegacyConfigClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@LegacyConfig method", EmptyStringLegacyConfigClass.class.getName(), "setValue", "null or empty value");
    }

    @Test
    public void testEmptyArrayLegacyConfigClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(EmptyArrayLegacyConfigClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, EmptyArrayLegacyConfigClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@LegacyConfig method", EmptyArrayLegacyConfigClass.class.getName(), "setValue", "empty list");
    }

    @Test
    public void testEmptyStringInArrayLegacyConfigClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(EmptyStringInArrayLegacyConfigClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, EmptyStringInArrayLegacyConfigClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@LegacyConfig method", EmptyStringInArrayLegacyConfigClass.class.getName(), "setValue", "null or empty value");
    }

    @Test
    public void testLegacyConfigDuplicatesConfigClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(LegacyConfigDuplicatesConfigClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        this.verifyMetaData(metadata, LegacyConfigDuplicatesConfigClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@Config property", "'value'", "appears in @LegacyConfig", "setValue");
    }

    @Test
    public void testLegacyConfigDuplicatesConfigOnOtherMethodClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(LegacyConfigDuplicatesConfigOnOtherMethodClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, LegacyConfigDuplicatesConfigOnOtherMethodClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(2);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@LegacyConfig", "'value'", "is replaced by @Config", "same name", "setValue");
        monitor.assertMatchingErrorRecorded("@LegacyConfig", "setValue", "not associated with any valid @Config");
    }

    @Test
    public void testLegacyConfigDuplicatesConfigOnLinkedMethodClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(LegacyConfigDuplicatesConfigOnLinkedMethodClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, LegacyConfigDuplicatesConfigOnLinkedMethodClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(2);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@LegacyConfig", "'value'", "is replaced by @Config", "same name", "setValue");
        monitor.assertMatchingErrorRecorded("@LegacyConfig", "setIntValue", "not associated with any valid @Config");
    }

    @Test
    public void testDeprecatedConfigClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(DeprecatedConfigClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        expectedAttributes.put("Deprecated", (Set<String>)ImmutableSet.of((Object)"deprecated-value"));
        this.verifyMetaData(metadata, DeprecatedConfigClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
    }

    @Test
    public void testDeprecatedConfigOnSetterOnlyClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(DeprecatedConfigOnSetterOnlyClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        expectedAttributes.put("Deprecated", (Set<String>)ImmutableSet.of((Object)"deprecated-value"));
        this.verifyMetaData(metadata, DeprecatedConfigOnSetterOnlyClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("getDeprecated", "setDeprecated", "must be @Deprecated together");
    }

    @Test
    public void testDeprecatedConfigOnGetterOnlyClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(DeprecatedConfigOnGetterOnlyClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        expectedAttributes.put("Deprecated", (Set<String>)ImmutableSet.of((Object)"deprecated-value"));
        this.verifyMetaData(metadata, DeprecatedConfigOnGetterOnlyClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("getDeprecated", "setDeprecated", "must be @Deprecated together");
    }

    @Test
    public void testDefunctConfigClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(DefunctConfigClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, DefunctConfigClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(0);
        monitor.assertNumberOfWarnings(0);
    }

    @Test
    public void testDefunctConfigEmptyArrayClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(DefunctConfigEmptyArrayClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, DefunctConfigEmptyArrayClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@DefunctConfig", "is empty");
    }

    @Test
    public void testDefunctConfigEmptyStringClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(DefunctConfigEmptyStringClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, DefunctConfigEmptyStringClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@DefunctConfig", "contains empty values");
    }

    @Test
    public void testDefunctConfigInUseClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(DefunctConfigInUseClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, DefunctConfigInUseClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@Config property", "'value'", "setValue", "is defunct on class");
    }

    @Test
    public void testDefunctConfigInLegacyUseClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(DefunctConfigInLegacyUseClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value", (Object)"replacedValue"));
        this.verifyMetaData(metadata, DefunctConfigInLegacyUseClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@LegacyConfig property", "'replacedValue'", "setValue", "is defunct on class");
    }

    @Test
    public void testDefunctConfigInLinkedLegacyUseClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(DefunctConfigInLinkedLegacyUseClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value", (Object)"replacedValue"));
        this.verifyMetaData(metadata, DefunctConfigInLinkedLegacyUseClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@LegacyConfig property", "'replacedValue'", "setIntValue", "is defunct on class");
    }

    @Test
    public void testDuplicateDefunctConfigClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(DuplicateDefunctConfigClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value"));
        this.verifyMetaData(metadata, DuplicateDefunctConfigClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("Defunct property", "'defunct'", "listed more than once");
    }

    @Test
    public void testLegacyConfigSensitiveClass() throws Exception {
        TestMonitor monitor = new TestMonitor();
        ConfigurationMetadata metadata = ConfigurationMetadata.getConfigurationMetadata(LegacyConfigSensitiveClass.class, (Problems.Monitor)monitor);
        HashMap<String, Set<String>> expectedAttributes = new HashMap<String, Set<String>>();
        expectedAttributes.put("Value", (Set<String>)ImmutableSet.of((Object)"value", (Object)"replacedValue"));
        this.verifyMetaData(metadata, LegacyConfigSensitiveClass.class, null, false, expectedAttributes);
        monitor.assertNumberOfErrors(1);
        monitor.assertNumberOfWarnings(0);
        monitor.assertMatchingErrorRecorded("@ConfigSecuritySensitive method", "setValue", "is not annotated with @Config.");
    }

    private void verifyMetaData(ConfigurationMetadata<?> metadata, Class<?> configClass, String description, boolean securitySensitive, Map<String, Set<String>> attributeProperties) throws Exception {
        Assert.assertEquals((Object)metadata.getConfigClass(), configClass);
        if (metadata.getConstructor() != null) {
            Assert.assertEquals((Object)metadata.getConstructor(), configClass.getDeclaredConstructor(new Class[0]));
        } else {
            try {
                configClass.getDeclaredConstructor(new Class[0]);
                Assert.fail((String)String.format("Expected configClass [%s] not to have a constructor", configClass.getName()));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Assert.assertEquals((int)metadata.getAttributes().size(), (int)attributeProperties.keySet().size());
        for (String name : attributeProperties.keySet()) {
            ConfigurationMetadata.AttributeMetadata attribute = (ConfigurationMetadata.AttributeMetadata)metadata.getAttributes().get(name);
            Assert.assertEquals((Object)attribute.getConfigClass(), configClass);
            HashSet<String> namesToTest = new HashSet<String>();
            namesToTest.add(attribute.getInjectionPoint().getProperty());
            for (ConfigurationMetadata.InjectionPointMetaData legacyInjectionPoint : attribute.getLegacyInjectionPoints()) {
                namesToTest.add(legacyInjectionPoint.getProperty());
            }
            Assert.assertEquals(namesToTest, attributeProperties.get(name));
            Assert.assertEquals((String)attribute.getDescription(), (String)description);
            Assert.assertEquals((boolean)attribute.isSecuritySensitive(), (boolean)securitySensitive);
        }
    }

    public static class LegacyConfigSensitiveClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Deprecated
        @LegacyConfig(value={"replacedValue"})
        @ConfigSecuritySensitive
        public void setValue(int value) {
            this.value = Integer.toString(value);
        }
    }

    @DefunctConfig(value={"defunct", "defunct"})
    public static class DuplicateDefunctConfigClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    @DefunctConfig(value={"replacedValue"})
    public static class DefunctConfigInLinkedLegacyUseClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Deprecated
        @LegacyConfig(value={"replacedValue"}, replacedBy="value")
        public void setIntValue(int value) {
            this.value = Integer.toString(value);
        }
    }

    @DefunctConfig(value={"replacedValue"})
    public static class DefunctConfigInLegacyUseClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Deprecated
        @LegacyConfig(value={"replacedValue"})
        public void setValue(int value) {
            this.value = Integer.toString(value);
        }
    }

    @DefunctConfig(value={"value"})
    public static class DefunctConfigInUseClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    @DefunctConfig(value={"defunct1", ""})
    public static class DefunctConfigEmptyStringClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    @DefunctConfig(value={})
    public static class DefunctConfigEmptyArrayClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    @DefunctConfig(value={"defunct1", "defunct2"})
    public static class DefunctConfigClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class DeprecatedConfigOnGetterOnlyClass {
        private String value;
        private String deprecated;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Deprecated
        public String getDeprecated() {
            return this.deprecated;
        }

        @Config(value="deprecated-value")
        public void setDeprecated(String deprecated) {
            this.deprecated = deprecated;
        }
    }

    public static class DeprecatedConfigOnSetterOnlyClass {
        private String value;
        private String deprecated;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        public String getDeprecated() {
            return this.deprecated;
        }

        @Deprecated
        @Config(value="deprecated-value")
        public void setDeprecated(String deprecated) {
            this.deprecated = deprecated;
        }
    }

    public static class DeprecatedConfigClass {
        private String value;
        private String deprecated;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Deprecated
        public String getDeprecated() {
            return this.deprecated;
        }

        @Deprecated
        @Config(value="deprecated-value")
        public void setDeprecated(String deprecated) {
            this.deprecated = deprecated;
        }
    }

    public static class LegacyConfigDuplicatesConfigOnLinkedMethodClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Deprecated
        @LegacyConfig(value={"value"}, replacedBy="value")
        public void setIntValue(int value) {
            this.value = Integer.toString(value);
        }
    }

    public static class LegacyConfigDuplicatesConfigOnOtherMethodClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Deprecated
        @LegacyConfig(value={"value"})
        public void setValue(int value) {
            this.value = Integer.toString(value);
        }
    }

    public static class LegacyConfigDuplicatesConfigClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        @LegacyConfig(value={"value"})
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class EmptyStringInArrayLegacyConfigClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        @LegacyConfig(value={"foo", ""})
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class EmptyArrayLegacyConfigClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        @LegacyConfig(value={})
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class EmptyStringLegacyConfigClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        @LegacyConfig(value={""})
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class MultipleLegacyConfigClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        @LegacyConfig(value={"legacy1", "legacy2"})
        @ConfigDescription(value="description")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class LegacyConfigOnNonDeprecatedSetterClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @LegacyConfig(value={"replacedValue"})
        public void setValue(int value) {
            this.value = Integer.toString(value);
        }
    }

    public static class LegacyConfigOnDeprecatedSetterClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Deprecated
        @LegacyConfig(value={"replacedValue"})
        public void setValue(int value) {
            this.value = Integer.toString(value);
        }
    }

    public static class LegacyConfigOnSetterClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @LegacyConfig(value={"replacedValue"})
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class LegacyConfigOnGetterClass {
        private String value;

        @LegacyConfig(value={"replacedValue"})
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class CurrentConfigWithReplacedByClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        public String getValueByOtherName() {
            return this.value;
        }

        @Config(value="other-name")
        public void setValueByOtherName(String value) {
            this.value = value;
        }

        @Config(value="value")
        @LegacyConfig(value={"replacedValue"}, replacedBy="other-name")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class CurrentAndLegacyConfigOnSetterClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        @LegacyConfig(value={"replacedValue"})
        @ConfigDescription(value="description")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class CurrentAndLegacyConfigOnGetterClass {
        private String value;

        @Config(value="value")
        @LegacyConfig(value={"replacedValue"})
        @ConfigDescription(value="description")
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class MultipleAnnotatedSettersClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Config(value="int-value")
        public void setValue(int value) {
            this.value = Integer.toString(value);
        }
    }

    public static class NotJavaBeanClass {
        private String value;

        public String fetchValue() {
            return this.value;
        }

        @Config(value="value")
        public void putValue(String value) {
            this.value = value;
        }
    }

    public static class SetterWithNoParameterClass {
        public String getValue() {
            return null;
        }

        @Config(value="value")
        public void setValue() {
        }
    }

    public static class IsMethodPrivateSetterClass {
        private boolean value;

        public boolean isValue() {
            return this.value;
        }

        @Config(value="value")
        private void setValue(boolean value) {
            this.value = value;
        }
    }

    public static class IsMethodMultipleSettersClass {
        private boolean value;

        public boolean isValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(boolean value) {
            this.value = value;
        }

        public void setValue(Object value) {
        }
    }

    public static class IsMethodNoSetterClass {
        @Config(value="value")
        public boolean isValue() {
            return false;
        }
    }

    public static class IsMethodNoReturnClass {
        public void isValue() {
        }

        @Config(value="value")
        public void setValue(boolean value) {
        }
    }

    public static class IsMethodWithParameterClass {
        private boolean value;

        public boolean isValue(boolean foo) {
            return this.value;
        }

        @Config(value="value")
        public void setValue(boolean value) {
            this.value = value;
        }
    }

    public static class GetterPrivateSetterClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        private void setValue(String value) {
            this.value = value;
        }
    }

    public static class GetterMultipleSettersClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        public void setValue(Object value) {
        }
    }

    public static class GetterNoSetterClass {
        @Config(value="value")
        public String getValue() {
            return null;
        }
    }

    public static class GetterNoReturnClass {
        public void getValue() {
        }

        @Config(value="value")
        public void setValue(String value) {
        }
    }

    public static class GetterWithParameterClass {
        private String value;

        public String getValue(String foo) {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class StaticAttributeClass {
        private static String value;

        public static String getValue() {
            return value;
        }

        @Config(value="value")
        public static void setValue(String v) {
            value = v;
        }
    }

    public static class NotPublicAttributeClass {
        private String value;

        String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class EmptyPropertyNameClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class GetterAndSetterAnnotatedClass {
        private String value;

        @Config(value="value")
        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class NoConfigMethodsClass {
    }

    public static class NotPublicConstructorClass {
        private String value;

        NotPublicConstructorClass() {
        }

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class NoNoArgConstructorClass {
        private String value;

        public NoNoArgConstructorClass(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    static class NotPublicClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static abstract class AbstractClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class SetterNoGetterConfigClass {
        @Config(value="value")
        public void setValue(String value) {
        }
    }

    public static class SetterInterfaceImpl
    implements SetterInterface {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }
    }

    public static interface SetterInterface {
        @Config(value="value")
        @ConfigDescription(value="description")
        public void setValue(String var1);
    }

    public static class SetterSensitiveClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        @ConfigSecuritySensitive
        @ConfigDescription(value="description")
        public void setValue(String value) {
            this.value = value;
        }

        public void setValue(Object value) {
            this.value = String.valueOf(value);
        }
    }

    public static class SetterSubConfigClass
    extends SetterConfigClass {
    }

    public static class SetterConfigClass {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="value")
        @ConfigDescription(value="description")
        public void setValue(String value) {
            this.value = value;
        }

        public void setValue(Object value) {
            this.value = String.valueOf(value);
        }
    }
}

