/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.configuration;

import com.facebook.airlift.configuration.ConfigurationLoader;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestConfigurationLoader {
    private File tempDir;

    @BeforeClass
    public void setup() throws IOException {
        this.tempDir = Files.createTempDir().getCanonicalFile();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testLoadsFromSystemProperties() throws IOException {
        System.setProperty("test", "foo");
        Map properties = ConfigurationLoader.loadProperties();
        Assert.assertEquals((String)((String)properties.get("test")), (String)"foo");
        System.getProperties().remove("test");
    }

    @Test
    public void testLoadsFromFile() throws IOException {
        File file = File.createTempFile("config", ".properties", this.tempDir);
        PrintStream out = new PrintStream(new FileOutputStream(file));
        try {
            out.print("test: foo");
        }
        catch (Exception e) {
            out.close();
        }
        System.setProperty("config", file.getAbsolutePath());
        Map properties = ConfigurationLoader.loadProperties();
        Assert.assertEquals((String)((String)properties.get("test")), (String)"foo");
        Assert.assertEquals((String)((String)properties.get("config")), (String)file.getAbsolutePath());
        System.getProperties().remove("config");
    }

    @Test
    public void testSystemOverridesFile() throws IOException {
        File file = File.createTempFile("config", ".properties", this.tempDir);
        PrintStream out = new PrintStream(new FileOutputStream(file));
        try {
            out.println("key1: original");
            out.println("key2: original");
        }
        catch (Exception e) {
            out.close();
        }
        System.setProperty("config", file.getAbsolutePath());
        System.setProperty("key1", "overridden");
        Map properties = ConfigurationLoader.loadProperties();
        Assert.assertEquals((String)((String)properties.get("config")), (String)file.getAbsolutePath());
        Assert.assertEquals((String)((String)properties.get("key1")), (String)"overridden");
        Assert.assertEquals((String)((String)properties.get("key2")), (String)"original");
        System.getProperties().remove("config");
    }
}

