/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.configuration;

import com.facebook.airlift.configuration.Problems;
import com.google.common.base.Joiner;
import com.google.inject.spi.Message;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;

class TestMonitor
implements Problems.Monitor {
    private List<Message> errors = new ArrayList<Message>();
    private List<Message> warnings = new ArrayList<Message>();

    TestMonitor() {
    }

    public void onError(Message error) {
        this.errors.add(error);
    }

    public void onWarning(Message warning) {
        this.warnings.add(warning);
    }

    public void assertNumberOfErrors(int expected) {
        Assert.assertEquals((int)this.errors.size(), (int)expected, (String)String.format("Number of errors is incorrect, actual errors: %s", this.errorsString()));
    }

    public void assertNumberOfWarnings(int expected) {
        Assert.assertEquals((int)this.warnings.size(), (int)expected, (String)String.format("Number of warnings is incorrect, actual warnings: %s", this.warningsString()));
    }

    public void assertMatchingWarningRecorded(String ... parts) {
        for (Message warning : this.warnings) {
            boolean matched = true;
            for (String part : parts) {
                if (warning.getMessage().contains(part)) continue;
                matched = false;
            }
            if (!matched) continue;
            return;
        }
        Assert.fail((String)String.format("Expected message (%s) not found in monitor warning list. Warnings: %s", Joiner.on((String)", ").join((Object[])parts), this.warningsString()));
    }

    public void assertMatchingErrorRecorded(String ... parts) {
        for (Message error : this.errors) {
            boolean matched = true;
            for (String part : parts) {
                if (error.getMessage().contains(part)) continue;
                matched = false;
            }
            if (!matched) continue;
            return;
        }
        Assert.fail((String)String.format("Expected message (%s) not found in monitor error list. Errors: %s", Joiner.on((String)", ").join((Object[])parts), this.errorsString()));
    }

    private String errorsString() {
        return this.messageListAsString(this.errors);
    }

    private String warningsString() {
        return this.messageListAsString(this.warnings);
    }

    private String messageListAsString(List<Message> list) {
        StringBuilder builder = new StringBuilder();
        for (Message message : list) {
            builder.append(message.getMessage()).append(", ");
        }
        return builder.toString();
    }
}

