/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.configuration.testing;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.Config1;
import com.facebook.airlift.configuration.LegacyConfig;
import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.airlift.testing.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestConfigAssertions {
    @Test
    public void testDefaults() {
        HashMap<String, Object> expectedAttributeValues = new HashMap<String, Object>();
        expectedAttributeValues.put("Name", "Dain");
        expectedAttributeValues.put("Email", "dain@proofpoint.com");
        expectedAttributeValues.put("Phone", null);
        expectedAttributeValues.put("HomePage", URI.create("http://iq80.com"));
        ConfigAssertions.assertDefaults(expectedAttributeValues, PersonConfig.class);
    }

    @Test
    public void testDefaultsFailNotDefault() {
        boolean pass = true;
        try {
            HashMap<String, Object> expectedAttributeValues = new HashMap<String, Object>();
            expectedAttributeValues.put("Name", "Dain");
            expectedAttributeValues.put("Email", "dain@proofpoint.com");
            expectedAttributeValues.put("Phone", "42");
            expectedAttributeValues.put("HomePage", URI.create("http://iq80.com"));
            ConfigAssertions.assertDefaults(expectedAttributeValues, PersonConfig.class);
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"Phone");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testDefaultsFailNotDefaultWithNullAttribute() {
        boolean pass = true;
        try {
            HashMap<String, Object> expectedAttributeValues = new HashMap<String, Object>();
            expectedAttributeValues.put("Name", "Dain");
            expectedAttributeValues.put("Email", "dain@proofpoint.com");
            expectedAttributeValues.put("Phone", null);
            expectedAttributeValues.put("HomePage", URI.create("http://example.com"));
            ConfigAssertions.assertDefaults(expectedAttributeValues, PersonConfig.class);
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"HomePage");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testDefaultsFailUnsupportedAttribute() {
        boolean pass = true;
        try {
            HashMap<String, Object> expectedAttributeValues = new HashMap<String, Object>();
            expectedAttributeValues.put("Name", "Dain");
            expectedAttributeValues.put("Email", "dain@proofpoint.com");
            expectedAttributeValues.put("Phone", null);
            expectedAttributeValues.put("HomePage", URI.create("http://iq80.com"));
            expectedAttributeValues.put("UnsupportedAttribute", "value");
            ConfigAssertions.assertDefaults(expectedAttributeValues, PersonConfig.class);
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"UnsupportedAttribute");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testDefaultsFailUntestedAttribute() {
        boolean pass = true;
        try {
            HashMap<String, String> expectedAttributeValues = new HashMap<String, String>();
            expectedAttributeValues.put("Name", "Dain");
            expectedAttributeValues.put("Email", "dain@proofpoint.com");
            expectedAttributeValues.put("Phone", null);
            ConfigAssertions.assertDefaults(expectedAttributeValues, PersonConfig.class);
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"HomePage");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testDefaultsFailDeprecatedAttribute() {
        boolean pass = true;
        try {
            HashMap<String, Object> expectedAttributeValues = new HashMap<String, Object>();
            expectedAttributeValues.put("Name", "Dain");
            expectedAttributeValues.put("Email", "dain@proofpoint.com");
            expectedAttributeValues.put("Phone", null);
            expectedAttributeValues.put("HomePageUrl", URI.create("http://iq80.com"));
            ConfigAssertions.assertDefaults(expectedAttributeValues, PersonConfig.class);
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"HomePageUrl");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"name", (Object)"Jenny").put((Object)"email", (Object)"jenny@compuserve.com").put((Object)"phone", (Object)"867-5309").put((Object)"home-page", (Object)"http://example.com").build();
        PersonConfig expected = new PersonConfig().setName("Jenny").setEmail("jenny@compuserve.com").setPhone("867-5309").setHomePage(URI.create("http://example.com"));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testExplicitPropertyMappingsFailUnsupportedProperty() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"name", (Object)"Jenny").put((Object)"email", (Object)"jenny@compuserve.com").put((Object)"phone", (Object)"867-5309").put((Object)"home-page", (Object)"http://example.com").put((Object)"unsupported-property", (Object)"value").build();
        PersonConfig expected = new PersonConfig().setName("Jenny").setEmail("jenny@compuserve.com").setPhone("867-5309").setHomePage(URI.create("http://example.com"));
        boolean pass = true;
        try {
            ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"unsupported-property");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testExplicitPropertyMappingsFailUntestedProperty() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"name", (Object)"Jenny").put((Object)"email", (Object)"jenny@compuserve.com").put((Object)"phone", (Object)"867-5309").build();
        PersonConfig expected = new PersonConfig().setName("Jenny").setEmail("jenny@compuserve.com").setPhone("867-5309");
        boolean pass = true;
        try {
            ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"home-page");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testExplicitPropertyMappingsFailHasDefaultProperty() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"name", (Object)"Dain").put((Object)"email", (Object)"jenny@compuserve.com").put((Object)"phone", (Object)"867-5309").put((Object)"home-page", (Object)"http://example.com").build();
        PersonConfig expected = new PersonConfig().setName("Jenny").setEmail("jenny@compuserve.com").setHomePage(URI.create("http://example.com")).setPhone("867-5309");
        boolean pass = true;
        try {
            ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"Name");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testExplicitPropertyMappingsFailNotEquivalent() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"name", (Object)"Jenny").put((Object)"email", (Object)"jenny@compuserve.com").put((Object)"phone", (Object)"867-5309").put((Object)"home-page", (Object)"http://example.com").build();
        PersonConfig expected = new PersonConfig().setName("Jenny").setEmail("jenny@compuserve.com").setHomePage(URI.create("http://yahoo.com")).setPhone("867-5309");
        boolean pass = true;
        try {
            ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"HomePage");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testNoDeprecatedProperties() {
        ImmutableMap currentProperties = new ImmutableMap.Builder().put((Object)"email", (Object)"alice@example.com").put((Object)"home-page", (Object)"http://example.com").build();
        ConfigAssertions.assertDeprecatedEquivalence(NoDeprecatedConfig.class, (Map)currentProperties, (Map[])new Map[0]);
    }

    @Test
    public void testDeprecatedProperties() {
        ImmutableMap currentProperties = new ImmutableMap.Builder().put((Object)"email", (Object)"alice@example.com").put((Object)"home-page", (Object)"http://example.com").build();
        ImmutableMap oldProperties = new ImmutableMap.Builder().put((Object)"exchange-id", (Object)"alice@example.com").put((Object)"home-page", (Object)"http://example.com").build();
        ImmutableMap olderProperties = new ImmutableMap.Builder().put((Object)"notes-id", (Object)"alice@example.com").put((Object)"home-page-url", (Object)"http://example.com").build();
        ConfigAssertions.assertDeprecatedEquivalence(PersonConfig.class, (Map)currentProperties, (Map[])new Map[]{oldProperties, olderProperties});
    }

    @Test
    public void testDeprecatedPropertiesFailUnsupportedProperties() {
        ImmutableMap currentProperties = new ImmutableMap.Builder().put((Object)"email", (Object)"alice@example.com").put((Object)"unsupported-property", (Object)"value").build();
        ImmutableMap oldProperties = new ImmutableMap.Builder().put((Object)"exchange-id", (Object)"alice@example.com").build();
        ImmutableMap olderProperties = new ImmutableMap.Builder().put((Object)"notes-id", (Object)"alice@example.com").build();
        boolean pass = true;
        try {
            ConfigAssertions.assertDeprecatedEquivalence(PersonConfig.class, (Map)currentProperties, (Map[])new Map[]{oldProperties, olderProperties});
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"unsupported-property");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testDeprecatedPropertiesFailUntestedProperties() {
        ImmutableMap currentProperties = new ImmutableMap.Builder().put((Object)"email", (Object)"alice@example.com").build();
        ImmutableMap oldProperties = new ImmutableMap.Builder().put((Object)"exchange-id", (Object)"alice@example.com").build();
        boolean pass = true;
        try {
            ConfigAssertions.assertDeprecatedEquivalence(PersonConfig.class, (Map)currentProperties, (Map[])new Map[]{oldProperties});
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"notes-id");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testDeprecatedPropertiesFailDeprecatedCurrentProperties() {
        ImmutableMap currentProperties = new ImmutableMap.Builder().put((Object)"notes-id", (Object)"alice@example.com").build();
        ImmutableMap oldProperties = new ImmutableMap.Builder().put((Object)"exchange-id", (Object)"alice@example.com").build();
        ImmutableMap olderProperties = new ImmutableMap.Builder().put((Object)"email", (Object)"alice@example.com").build();
        boolean pass = true;
        try {
            ConfigAssertions.assertDeprecatedEquivalence(PersonConfig.class, (Map)currentProperties, (Map[])new Map[]{oldProperties, olderProperties});
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"notes-id");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testRecordDefaults() throws Exception {
        PersonConfig config = ((PersonConfig)ConfigAssertions.recordDefaults(PersonConfig.class)).setName("Alice Apple").setEmail("alice@example.com").setPhone("1-976-alice").setHomePage(URI.create("http://alice.example.com"));
        ConfigAssertions.$$RecordedConfigData data = ConfigAssertions.getRecordedConfig((Object)config);
        PersonConfig instance = (PersonConfig)data.getInstance();
        Assert.assertNotSame((Object)instance, (Object)config);
        Assert.assertEquals((Set)data.getInvokedMethods(), (Set)ImmutableSet.of((Object)PersonConfig.class.getMethod("setName", String.class), (Object)PersonConfig.class.getMethod("setEmail", String.class), (Object)PersonConfig.class.getMethod("setPhone", String.class), (Object)PersonConfig.class.getMethod("setHomePage", URI.class)));
        Assert.assertEquals((String)instance.getName(), (String)"Alice Apple");
        Assert.assertEquals((String)instance.getEmail(), (String)"alice@example.com");
        Assert.assertEquals((String)instance.getPhone(), (String)"1-976-alice");
        Assert.assertEquals((Object)instance.getHomePage(), (Object)URI.create("http://alice.example.com"));
        Assert.assertEquals((String)config.getName(), (String)"Alice Apple");
        Assert.assertEquals((String)config.getEmail(), (String)"alice@example.com");
        Assert.assertEquals((String)config.getPhone(), (String)"1-976-alice");
        Assert.assertEquals((Object)config.getHomePage(), (Object)URI.create("http://alice.example.com"));
    }

    @Test
    public void testRecordedDefaults() throws Exception {
        ConfigAssertions.assertRecordedDefaults((Object)((PersonConfig)ConfigAssertions.recordDefaults(PersonConfig.class)).setName("Dain").setEmail("dain@proofpoint.com").setPhone(null).setHomePage(URI.create("http://iq80.com")));
    }

    @Test
    public void testRecordedDefaultsOneOfEverything() throws Exception {
        ConfigAssertions.assertRecordedDefaults((Object)((Config1)ConfigAssertions.recordDefaults(Config1.class)).setBooleanOption(false).setBoxedBooleanOption(null).setBoxedByteOption(null).setBoxedDoubleOption(null).setBoxedFloatOption(null).setBoxedIntegerOption(null).setBoxedLongOption(null).setBoxedShortOption(null).setByteOption((byte)0).setDoubleOption(0.0).setFloatOption(0.0f).setIntegerOption(0).setLongOption(0L).setMyEnumOption(null).setMyEnumSecondOption(null).setShortOption((short)0).setStringOption(null).setValueClassOption(null));
    }

    @Test
    public void testRecordedDefaultsFailInvokedDeprecatedSetter() throws MalformedURLException {
        boolean pass = true;
        try {
            ConfigAssertions.assertRecordedDefaults((Object)((PersonConfig)ConfigAssertions.recordDefaults(PersonConfig.class)).setName("Dain").setEmail("dain@proofpoint.com").setPhone(null).setHomePageUrl(new URL("http://iq80.com")));
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"HomePageUrl");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    @Test
    public void testRecordedDefaultsFailInvokedExtraMethod() {
        boolean pass = true;
        try {
            PersonConfig config = ((PersonConfig)ConfigAssertions.recordDefaults(PersonConfig.class)).setName("Dain").setEmail("dain@proofpoint.com").setPhone(null).setHomePage(URI.create("http://iq80.com"));
            config.hashCode();
            ConfigAssertions.assertRecordedDefaults((Object)config);
        }
        catch (AssertionError e) {
            pass = false;
            Assertions.assertContains((String)((Throwable)((Object)e)).getMessage(), (String)"hashCode()");
        }
        if (pass) {
            Assert.fail((String)"Expected AssertionError");
        }
    }

    public static class NoDeprecatedConfig {
        private String name = "Dain";
        private String email = "dain@proofpoint.com";
        private String phone;
        private URI homePage = URI.create("http://iq80.com");

        public String getName() {
            return this.name;
        }

        @Config(value="name")
        public NoDeprecatedConfig setName(String name) {
            this.name = name;
            return this;
        }

        public String getEmail() {
            return this.email;
        }

        @Config(value="email")
        public NoDeprecatedConfig setEmail(String email) {
            this.email = email;
            return this;
        }

        public String getPhone() {
            return this.phone;
        }

        @Config(value="phone")
        public NoDeprecatedConfig setPhone(String phone) {
            this.phone = phone;
            return this;
        }

        public URI getHomePage() {
            return this.homePage;
        }

        @Config(value="home-page")
        public NoDeprecatedConfig setHomePage(URI homePage) {
            this.homePage = homePage;
            return this;
        }
    }

    public static class PersonConfig {
        private String name = "Dain";
        private String email = "dain@proofpoint.com";
        private String phone;
        private URI homePage = URI.create("http://iq80.com");

        public String getName() {
            return this.name;
        }

        @Config(value="name")
        public PersonConfig setName(String name) {
            this.name = name;
            return this;
        }

        public String getEmail() {
            return this.email;
        }

        @Config(value="email")
        @LegacyConfig(value={"exchange-id", "notes-id"})
        public PersonConfig setEmail(String email) {
            this.email = email;
            return this;
        }

        public String getPhone() {
            return this.phone;
        }

        @Config(value="phone")
        public PersonConfig setPhone(String phone) {
            this.phone = phone;
            return this;
        }

        public URI getHomePage() {
            return this.homePage;
        }

        @Config(value="home-page")
        public PersonConfig setHomePage(URI homePage) {
            this.homePage = homePage;
            return this;
        }

        @LegacyConfig(value={"home-page-url"}, replacedBy="home-page")
        public PersonConfig setHomePageUrl(URL homePage) {
            try {
                this.homePage = homePage.toURI();
                return this;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

