/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.dbpool;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;

class ManagedSemaphore
extends Semaphore {
    private final AtomicLong activePermits = new AtomicLong();
    private int permits;

    public ManagedSemaphore(int permits) {
        super(permits);
        this.permits = permits;
    }

    @Managed
    public synchronized int getPermits() {
        return this.permits;
    }

    @Managed
    public synchronized void setPermits(int newPermits) {
        int delta = newPermits - this.permits;
        if (delta > 0) {
            super.release(delta);
        } else if (delta < 0) {
            super.reducePermits(-delta);
        }
        this.permits = newPermits;
    }

    @Managed
    public long getActivePermits() {
        return this.activePermits.get();
    }

    @Managed
    public int getAvailablePermits() {
        return super.availablePermits();
    }

    @Override
    public void acquire() throws InterruptedException {
        super.acquire();
        this.activePermits.incrementAndGet();
    }

    @Override
    public void acquireUninterruptibly() {
        super.acquireUninterruptibly();
        this.activePermits.incrementAndGet();
    }

    @Override
    public boolean tryAcquire() {
        if (super.tryAcquire()) {
            this.activePermits.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        if (super.tryAcquire(timeout, unit)) {
            this.activePermits.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        super.acquire(permits);
        this.activePermits.addAndGet(permits);
    }

    @Override
    public void acquireUninterruptibly(int permits) {
        super.acquireUninterruptibly(permits);
        this.activePermits.addAndGet(permits);
    }

    @Override
    public boolean tryAcquire(int permits) {
        if (super.tryAcquire(permits)) {
            this.activePermits.addAndGet(permits);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        if (super.tryAcquire(permits, timeout, unit)) {
            this.activePermits.addAndGet(permits);
            return true;
        }
        return false;
    }

    @Override
    public void release() {
        super.release();
        this.activePermits.decrementAndGet();
    }

    @Override
    public void release(int permits) {
        super.release(permits);
        this.activePermits.addAndGet(-permits);
    }

    @Override
    public int drainPermits() {
        int permits = super.drainPermits();
        this.activePermits.addAndGet(permits);
        return permits;
    }
}

