/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.dbpool;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.dbpool.MySqlDataSource;
import com.facebook.airlift.dbpool.MySqlDataSourceConfig;
import com.facebook.airlift.discovery.client.DiscoveryBinder;
import com.facebook.airlift.discovery.client.ServiceSelector;
import com.facebook.airlift.discovery.client.ServiceTypes;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.weakref.jmx.guice.ExportBinder;
import org.weakref.jmx.guice.MBeanModule;

public class MySqlDataSourceModule
implements Module {
    private final Class<? extends Annotation> annotation;
    private final List<Class<? extends Annotation>> aliases;
    private final String type;

    @SafeVarargs
    public MySqlDataSourceModule(String type, Class<? extends Annotation> annotation, Class<? extends Annotation> ... aliases) {
        if (annotation == null) {
            throw new NullPointerException("annotation is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.annotation = annotation;
        this.type = type;
        this.aliases = aliases != null ? ImmutableList.copyOf((Object[])aliases) : Collections.emptyList();
    }

    public void configure(Binder binder) {
        binder.install((Module)new MBeanModule());
        ConfigBinder.configBinder((Binder)binder).bindConfig(MySqlDataSourceConfig.class, this.annotation, this.type);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector(this.type);
        binder.bind(DataSource.class).annotatedWith(this.annotation).toProvider((Provider)new MySqlDataSourceProvider(this.type, this.annotation)).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DataSource.class).annotatedWith(this.annotation).withGeneratedName();
        Key key = Key.get(DataSource.class, this.annotation);
        for (Class<? extends Annotation> alias : this.aliases) {
            binder.bind(DataSource.class).annotatedWith(alias).to(key);
        }
    }

    private static class MySqlDataSourceProvider
    implements Provider<MySqlDataSource> {
        private final String type;
        private final Class<? extends Annotation> annotation;
        private Injector injector;

        private MySqlDataSourceProvider(String type, Class<? extends Annotation> annotation) {
            this.type = type;
            this.annotation = annotation;
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public MySqlDataSource get() {
            MySqlDataSourceConfig config = (MySqlDataSourceConfig)this.injector.getInstance(Key.get(MySqlDataSourceConfig.class, this.annotation));
            ServiceSelector serviceSelector = (ServiceSelector)this.injector.getInstance(Key.get(ServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)this.type)));
            return new MySqlDataSource(serviceSelector, config);
        }
    }
}

