/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.store;

import com.facebook.airlift.discovery.store.ConflictResolver;
import com.facebook.airlift.discovery.store.Entry;
import com.facebook.airlift.discovery.store.LocalStore;
import com.facebook.airlift.discovery.store.Version;
import jakarta.inject.Inject;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InMemoryStore
implements LocalStore {
    private final ConcurrentMap<ByteBuffer, Entry> map = new ConcurrentHashMap<ByteBuffer, Entry>();
    private final ConflictResolver resolver;

    @Inject
    public InMemoryStore(ConflictResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void put(Entry entry) {
        ByteBuffer key = ByteBuffer.wrap(entry.getKey());
        boolean done = false;
        while (!done) {
            Entry old = this.map.putIfAbsent(key, entry);
            done = true;
            if (old == null || (entry = this.resolver.resolve(old, entry)) == old) continue;
            done = this.map.replace(key, old, entry);
        }
    }

    @Override
    public Entry get(byte[] key) {
        Objects.requireNonNull(key, "key is null");
        return (Entry)this.map.get(ByteBuffer.wrap(key));
    }

    @Override
    public void delete(byte[] key, Version version) {
        Objects.requireNonNull(key, "key is null");
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        boolean done = false;
        while (!done) {
            Entry old = (Entry)this.map.get(wrappedKey);
            done = true;
            if (old == null || !EnumSet.of(Version.Occurs.AFTER, Version.Occurs.SAME).contains((Object)version.compare(old.getVersion()))) continue;
            done = this.map.remove(wrappedKey, old);
        }
    }

    @Override
    public Iterable<Entry> getAll() {
        return this.map.values();
    }
}

