/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.store;

import com.facebook.airlift.discovery.store.Entry;
import com.facebook.airlift.discovery.store.LocalStore;
import com.facebook.airlift.discovery.store.PersistentStoreConfig;
import com.facebook.airlift.discovery.store.Version;
import com.facebook.airlift.log.Logger;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.function.Predicate;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.Iq80DBFactory;

public class PersistentStore
implements LocalStore {
    private static final Logger log = Logger.get(PersistentStore.class);
    private final DB db;
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new SmileFactory());

    @Inject
    public PersistentStore(PersistentStoreConfig config) throws IOException {
        this.db = Iq80DBFactory.factory.open(config.getLocation(), new Options().createIfMissing(true));
    }

    @Override
    public void put(Entry entry) {
        byte[] dbEntry;
        try {
            dbEntry = this.mapper.writeValueAsBytes((Object)entry);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.db.put(entry.getKey(), dbEntry);
    }

    @Override
    public Entry get(byte[] key) {
        try {
            return (Entry)this.mapper.readValue(this.db.get(key), Entry.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void delete(byte[] key, Version version) {
        this.db.delete(key);
    }

    @Override
    public Iterable<Entry> getAll() {
        return (Iterable)Streams.stream((Iterable)this.db).map(dbEntry -> {
            try {
                return (Entry)this.mapper.readValue((byte[])dbEntry.getValue(), Entry.class);
            }
            catch (IOException e) {
                byte[] key = (byte[])dbEntry.getKey();
                log.error((Throwable)e, "Corrupt entry " + Arrays.toString(key));
                this.db.delete(key);
                return null;
            }
        }).filter((Predicate<Entry>)Predicates.notNull()).collect(ImmutableList.toImmutableList());
    }
}

