/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.server;

import com.facebook.airlift.discovery.server.DiscoveryConfig;
import com.facebook.airlift.discovery.server.DynamicAnnouncement;
import com.facebook.airlift.discovery.server.DynamicServiceAnnouncement;
import com.facebook.airlift.discovery.server.DynamicStore;
import com.facebook.airlift.discovery.server.ForDynamicStore;
import com.facebook.airlift.discovery.server.Id;
import com.facebook.airlift.discovery.server.Node;
import com.facebook.airlift.discovery.server.Service;
import com.facebook.airlift.discovery.store.DistributedStore;
import com.facebook.airlift.discovery.store.Entry;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.units.Duration;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ReplicatedDynamicStore
implements DynamicStore {
    private final DistributedStore store;
    private final Duration maxAge;
    private final JsonCodec<List<Service>> codec;
    private final Supplier<Set<Service>> servicesSupplier;

    @Inject
    public ReplicatedDynamicStore(@ForDynamicStore DistributedStore store, DiscoveryConfig config, JsonCodec<List<Service>> codec) {
        this.store = Objects.requireNonNull(store, "store is null");
        this.maxAge = Objects.requireNonNull(config, "config is null").getMaxAge();
        this.codec = Objects.requireNonNull(codec, "codec is null");
        this.servicesSupplier = ReplicatedDynamicStore.cachingSupplier(this.servicesSupplier(), config.getStoreCacheTtl());
    }

    @Override
    public void put(Id<Node> nodeId, DynamicAnnouncement announcement) {
        List services = (List)announcement.getServiceAnnouncements().stream().map(DynamicServiceAnnouncement.toServiceWith(nodeId, announcement.getLocation(), announcement.getPool())).collect(ImmutableList.toImmutableList());
        byte[] key = nodeId.getBytes();
        byte[] value = this.codec.toJsonBytes((Object)services);
        this.store.put(key, value, this.maxAge);
    }

    @Override
    public void delete(Id<Node> nodeId) {
        this.store.delete(nodeId.getBytes());
    }

    @Override
    public Set<Service> getAll() {
        return this.servicesSupplier.get();
    }

    @Override
    public Set<Service> get(String type) {
        return ImmutableSet.copyOf(this.getAll().stream().filter(Service.matchesType(type)).iterator());
    }

    @Override
    public Set<Service> get(String type, String pool) {
        return ImmutableSet.copyOf(this.getAll().stream().filter(service -> Service.matchesType(type).test((Service)service) && Service.matchesPool(pool).test((Service)service)).iterator());
    }

    private Supplier<Set<Service>> servicesSupplier() {
        return () -> {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Entry entry : this.store.getAll()) {
                builder.addAll((Iterable)this.codec.fromJson(entry.getValue()));
            }
            return builder.build();
        };
    }

    private static <T> Supplier<T> cachingSupplier(Supplier<T> supplier, Duration ttl) {
        if (ttl.toMillis() == 0L) {
            return supplier;
        }
        return Suppliers.memoizeWithExpiration(supplier::get, (long)ttl.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

