/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.server;

import com.facebook.airlift.discovery.server.DynamicAnnouncement;
import com.facebook.airlift.discovery.server.DynamicStore;
import com.facebook.airlift.discovery.server.Id;
import com.facebook.airlift.discovery.server.Node;
import com.facebook.airlift.node.NodeInfo;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;

@Path(value="/v1/announcement/{node_id}")
public class DynamicAnnouncementResource {
    private final NodeInfo nodeInfo;
    private final DynamicStore dynamicStore;

    @Inject
    public DynamicAnnouncementResource(DynamicStore dynamicStore, NodeInfo nodeInfo) {
        this.dynamicStore = dynamicStore;
        this.nodeInfo = nodeInfo;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response put(@PathParam(value="node_id") Id<Node> nodeId, @Context UriInfo uriInfo, DynamicAnnouncement announcement) {
        if (!this.nodeInfo.getEnvironment().equals(announcement.getEnvironment())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Environment mismatch. Expected: %s, Provided: %s", this.nodeInfo.getEnvironment(), announcement.getEnvironment())).build();
        }
        String location = (String)((Object)Objects.requireNonNullElse(announcement.getLocation(), "/somewhere/" + nodeId.toString()));
        DynamicAnnouncement announcementWithLocation = DynamicAnnouncement.copyOf(announcement).setLocation(location).build();
        this.dynamicStore.put(nodeId, announcementWithLocation);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @DELETE
    public Response delete(@PathParam(value="node_id") Id<Node> nodeId) {
        this.dynamicStore.delete(nodeId);
        return Response.noContent().build();
    }
}

