/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.server;

import com.facebook.airlift.discovery.server.Id;
import com.facebook.airlift.discovery.server.Node;
import com.facebook.airlift.discovery.server.Service;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import java.util.function.Function;

public class DynamicServiceAnnouncement {
    private final Id<Service> id;
    private final String type;
    private final Map<String, String> properties;

    @JsonCreator
    public DynamicServiceAnnouncement(@JsonProperty(value="id") Id<Service> id, @JsonProperty(value="type") String type, @JsonProperty(value="properties") Map<String, String> properties) {
        this.id = id;
        this.type = type;
        this.properties = properties != null ? ImmutableMap.copyOf(properties) : null;
    }

    @NotNull
    public Id<Service> getId() {
        return this.id;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicServiceAnnouncement that = (DynamicServiceAnnouncement)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServiceAnnouncement{id=" + String.valueOf(this.id) + ", type='" + this.type + "', properties=" + String.valueOf(this.properties) + "}";
    }

    public static Function<DynamicServiceAnnouncement, Service> toServiceWith(Id<Node> nodeId, String location, String pool) {
        return announcement -> new Service(announcement.getId(), nodeId, announcement.getType(), pool, location, announcement.getProperties());
    }
}

