/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.server;

import com.facebook.airlift.discovery.server.Id;
import com.facebook.airlift.discovery.server.Service;
import com.facebook.airlift.discovery.server.Services;
import com.facebook.airlift.discovery.server.StaticAnnouncement;
import com.facebook.airlift.discovery.server.StaticStore;
import com.facebook.airlift.node.NodeInfo;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Objects;

@Path(value="/v1/announcement/static")
public class StaticAnnouncementResource {
    private final StaticStore store;
    private final NodeInfo nodeInfo;

    @Inject
    public StaticAnnouncementResource(StaticStore store, NodeInfo nodeInfo) {
        this.store = store;
        this.nodeInfo = nodeInfo;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response post(StaticAnnouncement announcement, @Context UriInfo uriInfo) {
        if (!this.nodeInfo.getEnvironment().equals(announcement.getEnvironment())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Environment mismatch. Expected: %s, Provided: %s", this.nodeInfo.getEnvironment(), announcement.getEnvironment())).build();
        }
        Id<Service> id = Id.random();
        String location = (String)((Object)Objects.requireNonNullElse(announcement.getLocation(), "/somewhere/" + String.valueOf(id)));
        Service service = Service.copyOf(announcement).setId(id).setLocation(location).build();
        this.store.put(service);
        URI uri = UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path(StaticAnnouncementResource.class).path("{id}").build(new Object[]{id});
        return Response.created((URI)uri).entity((Object)service).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Services get() {
        return new Services(this.nodeInfo.getEnvironment(), this.store.getAll());
    }

    @DELETE
    @Path(value="{id}")
    public void delete(@PathParam(value="id") Id<Service> id) {
        this.store.delete(id);
    }
}

