/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.client;

import com.facebook.airlift.discovery.client.Announcer;
import com.facebook.airlift.discovery.client.ServiceAnnouncement;
import com.facebook.airlift.discovery.client.ServiceDescriptor;
import com.facebook.airlift.discovery.client.ServiceSelector;
import com.facebook.airlift.node.NodeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MergingServiceSelector
implements ServiceSelector {
    private final ServiceSelector selector;
    private final Announcer announcer;
    private final NodeInfo nodeInfo;

    public MergingServiceSelector(ServiceSelector selector, Announcer announcer, NodeInfo nodeInfo) {
        this.selector = Objects.requireNonNull(selector, "selector is null");
        this.announcer = Objects.requireNonNull(announcer, "announcer is null");
        this.nodeInfo = Objects.requireNonNull(nodeInfo, "nodeInfo is null");
    }

    @Override
    public String getType() {
        return this.selector.getType();
    }

    @Override
    public String getPool() {
        return this.selector.getPool();
    }

    @Override
    public List<ServiceDescriptor> selectAllServices() {
        return this.merge(this.announcer.getServiceAnnouncements(), this.selector.selectAllServices());
    }

    @Override
    public ListenableFuture<List<ServiceDescriptor>> refresh() {
        return FluentFuture.from(this.selector.refresh()).transform(descriptors -> this.merge(this.announcer.getServiceAnnouncements(), (List<ServiceDescriptor>)descriptors), MoreExecutors.directExecutor());
    }

    private List<ServiceDescriptor> merge(Set<ServiceAnnouncement> serviceAnnouncements, List<ServiceDescriptor> serviceDescriptors) {
        HashSet<ServiceDescriptor> set = new HashSet<ServiceDescriptor>();
        for (ServiceAnnouncement announcement : serviceAnnouncements) {
            ServiceDescriptor descriptor = announcement.toServiceDescriptor(this.nodeInfo);
            if (!descriptor.getType().equals(this.getType()) || !descriptor.getPool().equals(this.getPool())) continue;
            set.add(descriptor);
        }
        set.addAll(serviceDescriptors);
        return ImmutableList.copyOf(set);
    }
}

