/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.client;

import com.facebook.airlift.discovery.client.Announcement;
import com.facebook.airlift.discovery.client.ServiceAnnouncement;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.testing.EquivalenceTester;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAnnouncement {
    private final JsonCodec<Announcement> announcementCodec = JsonCodec.jsonCodec(Announcement.class);
    private final JsonCodec<Map<String, Object>> objectCodec = JsonCodec.mapJsonCodec(String.class, Object.class);

    @Test
    public void testJsonEncode() throws Exception {
        Announcement announcement = new Announcement("environment", "node", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").addProperty("http", "http://localhost:8080").addProperty("jmx", "jmx://localhost:1234").build()));
        Map actual = (Map)this.objectCodec.fromJson(this.announcementCodec.toJson((Object)announcement));
        String json = Resources.toString((URL)Resources.getResource((String)"announcement.json"), (Charset)StandardCharsets.UTF_8);
        Map expected = (Map)this.objectCodec.fromJson(json);
        List<Map<String, Object>> services = TestAnnouncement.toServices(expected.get("services"));
        services.get(0).put("id", ((ServiceAnnouncement)Iterables.getOnlyElement((Iterable)announcement.getServices())).getId().toString());
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    private static List<Map<String, Object>> toServices(Object value) {
        return (List)value;
    }

    @Test
    public void testToString() {
        Assert.assertNotNull((Object)new Announcement("environment", "node", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").addProperty("http", "http://localhost:8080").addProperty("jmx", "jmx://localhost:1234").build())));
    }

    @Test
    public void testEquivalence() {
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)new Announcement("environment", "node-A", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Object[]{new Announcement("ENVIRONMENT", "node-A", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Announcement("environment", "node-A", "pool", "LOCATION", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Announcement("environment", "node-A", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"FOO").build()))}).addEquivalentGroup((Object)new Announcement("environment", "node-B", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Object[]{new Announcement("environment-X", "node-B", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Announcement("environment", "node-B", "pool", "location-X", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build())), new Announcement("environment", "node-B", "pool", "location", (Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"bar").build()))}).check();
    }
}

