/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.client;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.discovery.client.Announcer;
import com.facebook.airlift.discovery.client.DiscoveryAnnouncementClient;
import com.facebook.airlift.discovery.client.DiscoveryException;
import com.facebook.airlift.discovery.client.ServiceAnnouncement;
import com.facebook.airlift.discovery.client.ServiceDescriptor;
import com.facebook.airlift.discovery.client.ServiceDescriptors;
import com.facebook.airlift.discovery.client.ServiceType;
import com.facebook.airlift.discovery.client.ServiceTypes;
import com.facebook.airlift.discovery.client.testing.InMemoryDiscoveryClient;
import com.facebook.airlift.node.NodeConfig;
import com.facebook.airlift.node.NodeInfo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestAnnouncer {
    public static final Duration MAX_AGE = new Duration(1.0, TimeUnit.MILLISECONDS);
    private final ServiceType serviceType = ServiceTypes.serviceType((String)"foo");
    private Announcer announcer;
    private InMemoryDiscoveryClient discoveryClient;
    private ServiceAnnouncement serviceAnnouncement;
    private NodeInfo nodeInfo;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.nodeInfo = new NodeInfo(new NodeConfig().setEnvironment("test").setPool("pool"));
        this.discoveryClient = new InMemoryDiscoveryClient(this.nodeInfo, MAX_AGE);
        this.serviceAnnouncement = ServiceAnnouncement.serviceAnnouncement((String)this.serviceType.value()).addProperty("a", "apple").build();
        this.announcer = new Announcer((DiscoveryAnnouncementClient)this.discoveryClient, (Set)ImmutableSet.of((Object)this.serviceAnnouncement));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.announcer.destroy();
        this.assertAnnounced(new ServiceAnnouncement[0]);
    }

    @Test
    public void testBasic() throws Exception {
        this.assertAnnounced(new ServiceAnnouncement[0]);
        this.announcer.start();
        this.assertAnnounced(this.serviceAnnouncement);
    }

    @Test
    public void startAfterDestroy() throws Exception {
        this.announcer.start();
        this.announcer.destroy();
        try {
            this.announcer.start();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void idempotentStart() throws Exception {
        this.announcer.start();
        this.announcer.start();
        this.announcer.start();
    }

    @Test
    public void idempotentDestroy() throws Exception {
        this.announcer.start();
        this.announcer.destroy();
        this.announcer.destroy();
        this.announcer.destroy();
    }

    @Test
    public void destroyNoStart() throws Exception {
        this.announcer.destroy();
    }

    @Test
    public void addAnnouncementAfterStart() throws Exception {
        this.assertAnnounced(new ServiceAnnouncement[0]);
        this.announcer.start();
        ServiceAnnouncement newAnnouncement = ServiceAnnouncement.serviceAnnouncement((String)this.serviceType.value()).addProperty("a", "apple").build();
        this.announcer.addServiceAnnouncement(newAnnouncement);
        Thread.sleep(100L);
        this.assertAnnounced(this.serviceAnnouncement, newAnnouncement);
    }

    @Test
    public void removeAnnouncementAfterStart() throws Exception {
        this.assertAnnounced(new ServiceAnnouncement[0]);
        this.announcer.start();
        this.announcer.removeServiceAnnouncement(this.serviceAnnouncement.getId());
        Thread.sleep(100L);
        this.assertAnnounced(new ServiceAnnouncement[0]);
    }

    private void assertAnnounced(ServiceAnnouncement ... serviceAnnouncements) {
        ListenableFuture future = this.discoveryClient.getServices(this.serviceType.value(), "pool");
        ServiceDescriptors serviceDescriptors = (ServiceDescriptors)MoreFutures.getFutureValue((Future)future, DiscoveryException.class);
        Assert.assertEquals((String)serviceDescriptors.getType(), (String)this.serviceType.value());
        Assert.assertEquals((String)serviceDescriptors.getPool(), (String)"pool");
        Assert.assertNotNull((Object)serviceDescriptors.getETag());
        Assert.assertEquals((Object)serviceDescriptors.getMaxAge(), (Object)MAX_AGE);
        List descriptors = serviceDescriptors.getServiceDescriptors();
        Assert.assertEquals((int)descriptors.size(), (int)serviceAnnouncements.length);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ServiceDescriptor descriptor : descriptors) {
            builder.put((Object)descriptor.getId(), (Object)descriptor);
        }
        ImmutableMap descriptorMap = builder.build();
        for (ServiceAnnouncement serviceAnnouncement : serviceAnnouncements) {
            ServiceDescriptor serviceDescriptor = (ServiceDescriptor)descriptorMap.get(serviceAnnouncement.getId());
            Assert.assertNotNull((Object)serviceDescriptor, (String)("No descriptor for announcement " + serviceAnnouncement.getId()));
            Assert.assertEquals((String)serviceDescriptor.getType(), (String)this.serviceType.value());
            Assert.assertEquals((String)serviceDescriptor.getPool(), (String)"pool");
            Assert.assertEquals((Object)serviceDescriptor.getId(), (Object)serviceAnnouncement.getId());
            Assert.assertEquals((Map)serviceDescriptor.getProperties(), (Map)serviceAnnouncement.getProperties());
            Assert.assertEquals((String)serviceDescriptor.getNodeId(), (String)this.nodeInfo.getNodeId());
        }
    }
}

