/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.client;

import com.facebook.airlift.discovery.client.ServiceDescriptorsRepresentation;
import com.facebook.airlift.discovery.client.ServiceInventory;
import com.facebook.airlift.discovery.client.ServiceInventoryConfig;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.node.NodeInfo;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestServiceInventory {
    @Test
    public void testNullServiceInventory() {
        try (JettyHttpClient httpClient = new JettyHttpClient();){
            ServiceInventory serviceInventory = new ServiceInventory(new ServiceInventoryConfig(), new NodeInfo("test"), JsonCodec.jsonCodec(ServiceDescriptorsRepresentation.class), (HttpClient)httpClient);
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors()), (int)0);
            serviceInventory.updateServiceInventory();
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors()), (int)0);
        }
    }

    @Test
    public void testFileServiceInventory() throws Exception {
        try (JettyHttpClient httpClient = new JettyHttpClient();){
            ServiceInventoryConfig serviceInventoryConfig = new ServiceInventoryConfig().setServiceInventoryUri(Resources.getResource((String)"service-inventory.json").toURI());
            ServiceInventory serviceInventory = new ServiceInventory(serviceInventoryConfig, new NodeInfo("test"), JsonCodec.jsonCodec(ServiceDescriptorsRepresentation.class), (HttpClient)httpClient);
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors()), (int)2);
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors("discovery")), (int)2);
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors("discovery", "general")), (int)2);
            serviceInventory.updateServiceInventory();
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors()), (int)2);
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors("discovery")), (int)2);
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors("discovery", "general")), (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpServiceInventory() throws Exception {
        String serviceInventoryJson = Resources.toString((URL)Resources.getResource((String)"service-inventory.json"), (Charset)StandardCharsets.UTF_8);
        Server server = null;
        try (JettyHttpClient httpClient = new JettyHttpClient();){
            int port;
            try (ServerSocket socket = new ServerSocket();){
                socket.bind(new InetSocketAddress(0));
                port = socket.getLocalPort();
            }
            URI baseURI = new URI("http", null, "127.0.0.1", port, null, null, null);
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            httpConfiguration.setSendServerVersion(false);
            httpConfiguration.setSendXPoweredBy(false);
            server = new Server();
            ServerConnector httpConnector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
            httpConnector.setPort(port);
            httpConnector.setName("http");
            server.addConnector((Connector)httpConnector);
            ServletHolder servletHolder = new ServletHolder((Servlet)new ServiceInventoryServlet(serviceInventoryJson));
            ServletContextHandler context = new ServletContextHandler(0);
            context.addServlet(servletHolder, "/*");
            HandlerCollection handlers = new HandlerCollection();
            handlers.addHandler((Handler)context);
            server.setHandler((Handler)handlers);
            server.start();
            ServiceInventoryConfig serviceInventoryConfig = new ServiceInventoryConfig().setServiceInventoryUri(baseURI);
            ServiceInventory serviceInventory = new ServiceInventory(serviceInventoryConfig, new NodeInfo("test"), JsonCodec.jsonCodec(ServiceDescriptorsRepresentation.class), (HttpClient)httpClient);
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors()), (int)2);
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors("discovery")), (int)2);
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors("discovery", "general")), (int)2);
            serviceInventory.updateServiceInventory();
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors()), (int)2);
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors("discovery")), (int)2);
            Assert.assertEquals((int)Iterables.size((Iterable)serviceInventory.getServiceDescriptors("discovery", "general")), (int)2);
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    private class ServiceInventoryServlet
    extends HttpServlet {
        private final byte[] serviceInventory;

        private ServiceInventoryServlet(String serviceInventory) {
            this.serviceInventory = serviceInventory.getBytes(StandardCharsets.UTF_8);
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setHeader("Content-Type", "application/json");
            response.setStatus(200);
            response.getOutputStream().write(this.serviceInventory);
        }
    }
}

