/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.client;

import com.facebook.airlift.configuration.ConfigurationFactory;
import com.facebook.airlift.configuration.ConfigurationModule;
import com.facebook.airlift.discovery.client.DiscoveryBinder;
import com.facebook.airlift.discovery.client.HttpServiceSelector;
import com.facebook.airlift.discovery.client.ServiceAnnouncement;
import com.facebook.airlift.discovery.client.ServiceSelectorManager;
import com.facebook.airlift.discovery.client.ServiceTypes;
import com.facebook.airlift.discovery.client.testing.InMemoryDiscoveryClient;
import com.facebook.airlift.discovery.client.testing.TestingDiscoveryModule;
import com.facebook.airlift.node.testing.TestingNodeModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHttpServiceSelectorBinder {
    @Test
    public void testHttpSelectorString() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)ImmutableMap.of())), new TestingNodeModule(), new TestingDiscoveryModule(), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpSelector("apple")});
        InMemoryDiscoveryClient discoveryClient = (InMemoryDiscoveryClient)injector.getInstance(InMemoryDiscoveryClient.class);
        discoveryClient.announce((Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("http", "fake://server-http").build()));
        HttpServiceSelector selector = (HttpServiceSelector)injector.getInstance(Key.get(HttpServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"apple")));
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)selector.selectHttpService()), (Object)URI.create("fake://server-http"));
    }

    @Test
    public void testHttpSelectorAnnotation() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)ImmutableMap.of())), new TestingNodeModule(), new TestingDiscoveryModule(), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpSelector(ServiceTypes.serviceType((String)"apple"))});
        InMemoryDiscoveryClient discoveryClient = (InMemoryDiscoveryClient)injector.getInstance(InMemoryDiscoveryClient.class);
        discoveryClient.announce((Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("http", "fake://server-http").build()));
        HttpServiceSelector selector = (HttpServiceSelector)injector.getInstance(Key.get(HttpServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"apple")));
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)selector.selectHttpService()), (Object)URI.create("fake://server-http"));
        ServiceSelectorManager manager = (ServiceSelectorManager)injector.getInstance(ServiceSelectorManager.class);
        Assert.assertEquals((int)manager.getServiceSelectors().size(), (int)1);
        manager.attemptRefresh();
        manager.forceRefresh();
    }

    @Test
    public void testHttpsSelector() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)ImmutableMap.of())), new TestingNodeModule(), new TestingDiscoveryModule(), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpSelector("apple")});
        InMemoryDiscoveryClient discoveryClient = (InMemoryDiscoveryClient)injector.getInstance(InMemoryDiscoveryClient.class);
        discoveryClient.announce((Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("https", "fake://server-https").build()));
        HttpServiceSelector selector = (HttpServiceSelector)injector.getInstance(Key.get(HttpServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"apple")));
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)selector.selectHttpService()), (Object)URI.create("fake://server-https"));
    }

    @Test
    public void testFavorHttpsOverHttpSelector() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)ImmutableMap.of())), new TestingNodeModule(), new TestingDiscoveryModule(), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpSelector("apple")});
        InMemoryDiscoveryClient discoveryClient = (InMemoryDiscoveryClient)injector.getInstance(InMemoryDiscoveryClient.class);
        discoveryClient.announce((Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("http", "fake://server-http").build(), (Object)ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("https", "fake://server-https").build()));
        HttpServiceSelector selector = (HttpServiceSelector)injector.getInstance(Key.get(HttpServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"apple")));
        Assert.assertEquals((Collection)selector.selectHttpService(), (Collection)ImmutableList.of((Object)URI.create("fake://server-https"), (Object)URI.create("fake://server-http")));
    }

    @Test
    public void testNoHttpServices() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)ImmutableMap.of())), new TestingNodeModule(), new TestingDiscoveryModule(), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpSelector("apple")});
        InMemoryDiscoveryClient discoveryClient = (InMemoryDiscoveryClient)injector.getInstance(InMemoryDiscoveryClient.class);
        discoveryClient.announce((Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("foo", "fake://server-https").build()));
        HttpServiceSelector selector = (HttpServiceSelector)injector.getInstance(Key.get(HttpServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"apple")));
        Assert.assertEquals((Collection)selector.selectHttpService(), (Collection)ImmutableList.of());
    }

    @Test
    public void testInvalidUris() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigurationModule(new ConfigurationFactory((Map)ImmutableMap.of())), new TestingNodeModule(), new TestingDiscoveryModule(), binder -> DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpSelector("apple")});
        InMemoryDiscoveryClient discoveryClient = (InMemoryDiscoveryClient)injector.getInstance(InMemoryDiscoveryClient.class);
        discoveryClient.announce((Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("http", ":::INVALID:::").build()));
        discoveryClient.announce((Set)ImmutableSet.of((Object)ServiceAnnouncement.serviceAnnouncement((String)"apple").addProperty("https", ":::INVALID:::").build()));
        HttpServiceSelector selector = (HttpServiceSelector)injector.getInstance(Key.get(HttpServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"apple")));
        Assert.assertEquals((Collection)selector.selectHttpService(), (Collection)ImmutableList.of());
    }
}

