/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.client;

import com.facebook.airlift.discovery.client.ServiceAnnouncement;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.testing.EquivalenceTester;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestServiceAnnouncement {
    private final JsonCodec<ServiceAnnouncement> serviceAnnouncementCodec = JsonCodec.jsonCodec(ServiceAnnouncement.class);
    private final JsonCodec<Map<String, Object>> objectCodec = JsonCodec.mapJsonCodec(String.class, Object.class);

    @Test
    public void testBuilder() {
        this.assertAnnouncement(ServiceAnnouncement.serviceAnnouncement((String)"foo").build(), "foo", (Map<String, String>)ImmutableMap.of());
        this.assertAnnouncement(ServiceAnnouncement.serviceAnnouncement((String)"foo").build(), "foo", (Map<String, String>)ImmutableMap.of());
        this.assertAnnouncement(ServiceAnnouncement.serviceAnnouncement((String)"foo").addProperty("a", "apple").build(), "foo", (Map<String, String>)ImmutableMap.of((Object)"a", (Object)"apple"));
        this.assertAnnouncement(ServiceAnnouncement.serviceAnnouncement((String)"foo").addProperties((Map)ImmutableMap.of((Object)"a", (Object)"apple", (Object)"b", (Object)"banana")).build(), "foo", (Map<String, String>)ImmutableMap.of((Object)"a", (Object)"apple", (Object)"b", (Object)"banana"));
    }

    private void assertAnnouncement(ServiceAnnouncement announcement, String type, Map<String, String> properties) {
        Assert.assertNotNull((Object)announcement.getId());
        Assert.assertEquals((String)announcement.getType(), (String)type);
        Assert.assertEquals((Map)announcement.getProperties(), properties);
    }

    @Test
    public void testToString() {
        Assert.assertNotNull((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").build());
    }

    @Test
    public void testJsonEncode() throws Exception {
        ServiceAnnouncement serviceAnnouncement = ServiceAnnouncement.serviceAnnouncement((String)"foo").addProperty("http", "http://localhost:8080").addProperty("jmx", "jmx://localhost:1234").build();
        Map actual = (Map)this.objectCodec.fromJson(this.serviceAnnouncementCodec.toJson((Object)serviceAnnouncement));
        String json = Resources.toString((URL)Resources.getResource((String)"service-announcement.json"), (Charset)StandardCharsets.UTF_8);
        Map expected = (Map)this.objectCodec.fromJson(json);
        expected.put("id", serviceAnnouncement.getId().toString());
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test
    public void testEquivalence() {
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").addProperty("http", "http://localhost:8080").addProperty("jmx", "jmx://localhost:1234").build(), new Object[0]).addEquivalentGroup((Object)ServiceAnnouncement.serviceAnnouncement((String)"foo").addProperty("http", "http://localhost:8080").addProperty("jmx", "jmx://localhost:1234").build(), new Object[0]).check();
    }
}

