/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.client;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.discovery.client.AnnouncementHttpServerInfo;
import com.facebook.airlift.discovery.client.HttpServiceSelector;
import com.facebook.airlift.discovery.client.HttpServiceSelectorProvider;
import com.facebook.airlift.discovery.client.ServiceAnnouncement;
import com.facebook.airlift.discovery.client.ServiceSelector;
import com.facebook.airlift.discovery.client.ServiceSelectorConfig;
import com.facebook.airlift.discovery.client.ServiceSelectorProvider;
import com.facebook.airlift.discovery.client.ServiceType;
import com.facebook.airlift.discovery.client.ServiceTypes;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.inject.Provider;

public class DiscoveryBinder {
    private final Multibinder<ServiceSelector> serviceSelectorBinder;
    private final Multibinder<ServiceAnnouncement> serviceAnnouncementBinder;
    private final Binder binder;

    public static DiscoveryBinder discoveryBinder(Binder binder) {
        Objects.requireNonNull(binder, "binder is null");
        return new DiscoveryBinder(binder);
    }

    protected DiscoveryBinder(Binder binder) {
        Objects.requireNonNull(binder, "binder is null");
        this.binder = binder.skipSources(new Class[]{this.getClass()});
        this.serviceSelectorBinder = Multibinder.newSetBinder((Binder)binder, ServiceSelector.class);
        this.serviceAnnouncementBinder = Multibinder.newSetBinder((Binder)binder, ServiceAnnouncement.class);
    }

    public void bindSelector(String type) {
        Objects.requireNonNull(type, "type is null");
        this.bindSelector(ServiceTypes.serviceType(type));
    }

    public void bindSelector(ServiceType serviceType) {
        Objects.requireNonNull(serviceType, "serviceType is null");
        ConfigBinder.configBinder((Binder)this.binder).bindConfig(ServiceSelectorConfig.class, (Annotation)serviceType, "discovery." + serviceType.value());
        Key key = Key.get(ServiceSelector.class, (Annotation)serviceType);
        this.binder.bind(key).toProvider((Provider)new ServiceSelectorProvider(serviceType.value())).in(Scopes.SINGLETON);
        this.serviceSelectorBinder.addBinding().to(key).in(Scopes.SINGLETON);
    }

    public void bindServiceAnnouncement(ServiceAnnouncement announcement) {
        Objects.requireNonNull(announcement, "announcement is null");
        this.serviceAnnouncementBinder.addBinding().toInstance((Object)announcement);
    }

    public void bindServiceAnnouncement(Provider<ServiceAnnouncement> announcementProvider) {
        Objects.requireNonNull(announcementProvider, "announcementProvider is null");
        this.serviceAnnouncementBinder.addBinding().toProvider(announcementProvider);
    }

    public <T extends ServiceAnnouncement> void bindServiceAnnouncement(Class<? extends Provider<T>> announcementProviderClass) {
        Objects.requireNonNull(announcementProviderClass, "announcementProviderClass is null");
        this.serviceAnnouncementBinder.addBinding().toProvider(announcementProviderClass);
    }

    public ServiceAnnouncement.ServiceAnnouncementBuilder bindHttpAnnouncement(String type) {
        ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder = ServiceAnnouncement.serviceAnnouncement(type);
        this.bindServiceAnnouncement(new HttpAnnouncementProvider(serviceAnnouncementBuilder));
        return serviceAnnouncementBuilder;
    }

    public void bindHttpSelector(String type) {
        Objects.requireNonNull(type, "type is null");
        this.bindHttpSelector(ServiceTypes.serviceType(type));
    }

    public void bindHttpSelector(ServiceType serviceType) {
        Objects.requireNonNull(serviceType, "serviceType is null");
        this.bindSelector(serviceType);
        this.binder.bind(HttpServiceSelector.class).annotatedWith((Annotation)serviceType).toProvider((Provider)new HttpServiceSelectorProvider(serviceType.value())).in(Scopes.SINGLETON);
    }

    static class HttpAnnouncementProvider
    implements Provider<ServiceAnnouncement> {
        private final ServiceAnnouncement.ServiceAnnouncementBuilder builder;
        private AnnouncementHttpServerInfo httpServerInfo;

        public HttpAnnouncementProvider(ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder) {
            this.builder = serviceAnnouncementBuilder;
        }

        @Inject
        public void setAnnouncementHttpServerInfo(AnnouncementHttpServerInfo httpServerInfo) {
            this.httpServerInfo = httpServerInfo;
        }

        public ServiceAnnouncement get() {
            if (this.httpServerInfo.getHttpUri() != null) {
                this.builder.addProperty("http", this.httpServerInfo.getHttpUri().toString());
                this.builder.addProperty("http-external", this.httpServerInfo.getHttpExternalUri().toString());
            }
            if (this.httpServerInfo.getHttpsUri() != null) {
                this.builder.addProperty("https", this.httpServerInfo.getHttpsUri().toString());
                this.builder.addProperty("https-external", this.httpServerInfo.getHttpsExternalUri().toString());
            }
            return this.builder.build();
        }
    }
}

