/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.server;

import com.facebook.airlift.discovery.server.DynamicStore;
import com.facebook.airlift.discovery.server.Service;
import com.facebook.airlift.discovery.server.Services;
import com.facebook.airlift.discovery.server.StaticStore;
import com.facebook.airlift.node.NodeInfo;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/v1/service")
public class ServiceResource {
    private final DynamicStore dynamicStore;
    private final StaticStore staticStore;
    private final NodeInfo node;

    @Inject
    public ServiceResource(DynamicStore dynamicStore, StaticStore staticStore, NodeInfo node) {
        this.dynamicStore = dynamicStore;
        this.staticStore = staticStore;
        this.node = node;
    }

    @GET
    @Path(value="{type}/{pool}")
    @Produces(value={"application/json"})
    public Services getServices(@PathParam(value="type") String type, @PathParam(value="pool") String pool) {
        return new Services(this.node.getEnvironment(), (Set<Service>)Sets.union(this.dynamicStore.get(type, pool), this.staticStore.get(type, pool)));
    }

    @GET
    @Path(value="{type}")
    @Produces(value={"application/json"})
    public Services getServices(@PathParam(value="type") String type) {
        return new Services(this.node.getEnvironment(), (Set<Service>)Sets.union(this.dynamicStore.get(type), this.staticStore.get(type)));
    }

    @GET
    @Produces(value={"application/json"})
    public Services getServices() {
        return new Services(this.node.getEnvironment(), (Set<Service>)Sets.union(this.dynamicStore.getAll(), this.staticStore.getAll()));
    }
}

