/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.airlift.units.Duration;
import com.facebook.drift.transport.client.Address;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class RetriesFailedException
extends Exception {
    private final int invocationAttempts;
    private final int failedConnections;
    private final Duration retryTime;
    private final int overloadedRejects;
    private final Set<? extends Address> attemptedAddresses;

    public RetriesFailedException(String reason, int invocationAttempts, Duration retryTime, int failedConnections, int overloadedRejects, Set<? extends Address> attemptedAddresses) {
        super(String.format("%s (invocationAttempts: %s, duration: %s, failedConnections: %s, overloadedRejects: %s, attemptedAddresses: %s)", reason, invocationAttempts, retryTime, failedConnections, overloadedRejects, attemptedAddresses));
        this.invocationAttempts = invocationAttempts;
        this.failedConnections = failedConnections;
        this.retryTime = Objects.requireNonNull(retryTime, "retryTime is null");
        this.overloadedRejects = overloadedRejects;
        this.attemptedAddresses = ImmutableSet.copyOf((Collection)Objects.requireNonNull(attemptedAddresses, "attemptedAddresses is null"));
    }

    public int getInvocationAttempts() {
        return this.invocationAttempts;
    }

    public int getFailedConnections() {
        return this.failedConnections;
    }

    public Duration getRetryTime() {
        return this.retryTime;
    }

    public int getOverloadedRejects() {
        return this.overloadedRejects;
    }

    public Set<? extends Address> getAttemptedAddresses() {
        return this.attemptedAddresses;
    }
}

