/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client.stats;

import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.airlift.units.Duration;
import com.facebook.drift.client.stats.MethodInvocationStat;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JmxMethodInvocationStat
implements MethodInvocationStat {
    private final String name;
    private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);
    private final CounterStat successes = new CounterStat();
    private final CounterStat failures = new CounterStat();
    private final CounterStat retries = new CounterStat();

    public JmxMethodInvocationStat(String name) {
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public String getName() {
        return this.name;
    }

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    @Managed
    @Nested
    public CounterStat getSuccesses() {
        return this.successes;
    }

    @Managed
    @Nested
    public CounterStat getFailures() {
        return this.failures;
    }

    @Managed
    @Nested
    public CounterStat getRetries() {
        return this.retries;
    }

    @Override
    public void recordResult(long startTime, ListenableFuture<Object> result) {
        result.addListener(() -> {
            this.time.add(Duration.nanosSince((long)startTime));
            try {
                result.get();
                this.successes.update(1L);
            }
            catch (Throwable throwable) {
                this.failures.update(1L);
            }
        }, MoreExecutors.directExecutor());
    }

    @Override
    public void recordRetry() {
        this.retries.update(1L);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("successes", this.successes.getTotalCount()).add("failures", this.failures.getTotalCount()).add("retries", this.retries.getTotalCount()).toString();
    }
}

