/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.utils;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.coercion.FromThrift;
import com.facebook.drift.codec.internal.coercion.ToThrift;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import jakarta.inject.Inject;
import java.util.Locale;
import java.util.Objects;

public class LocaleToLanguageTagCodec
implements ThriftCodec<Locale> {
    @Inject
    public LocaleToLanguageTagCodec(ThriftCatalog thriftCatalog) {
        thriftCatalog.addDefaultCoercions(this.getClass());
    }

    public ThriftType getType() {
        return new ThriftType(ThriftType.STRING, Locale.class);
    }

    public Locale read(TProtocolReader protocol) throws Exception {
        return LocaleToLanguageTagCodec.stringToLocale(protocol.readString());
    }

    public void write(Locale locale, TProtocolWriter protocol) throws Exception {
        protocol.writeString(LocaleToLanguageTagCodec.localeToString(locale));
    }

    @FromThrift
    public static Locale stringToLocale(String locale) {
        Objects.requireNonNull(locale, "locale is null");
        return Locale.forLanguageTag(locale);
    }

    @ToThrift
    public static String localeToString(Locale locale) {
        Objects.requireNonNull(locale, "locale is null");
        return locale.toLanguageTag();
    }
}

