/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.utils;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.coercion.FromThrift;
import com.facebook.drift.codec.internal.coercion.ToThrift;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;

public class UuidToLeachSalzBinaryEncodingThriftCodec
implements ThriftCodec<UUID> {
    @Inject
    public UuidToLeachSalzBinaryEncodingThriftCodec(ThriftCatalog thriftCatalog) {
        thriftCatalog.addDefaultCoercions(this.getClass());
    }

    public ThriftType getType() {
        return new ThriftType(ThriftType.BINARY, UUID.class);
    }

    public UUID read(TProtocolReader protocol) throws Exception {
        return UuidToLeachSalzBinaryEncodingThriftCodec.byteToUuid(protocol.readBinary());
    }

    public void write(UUID uuid, TProtocolWriter protocol) throws Exception {
        protocol.writeBinary(UuidToLeachSalzBinaryEncodingThriftCodec.uuidToBytes(uuid));
    }

    @FromThrift
    public static UUID byteToUuid(ByteBuffer bytes) {
        Objects.requireNonNull(bytes, "bytes is null");
        Preconditions.checkArgument((bytes.limit() == 16 ? 1 : 0) != 0, (Object)("Expected exactly 16 bytes, was: " + bytes.limit()));
        return new UUID(bytes.getLong(), bytes.getLong());
    }

    @ToThrift
    public static ByteBuffer uuidToBytes(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid is null");
        ByteBuffer bytes = ByteBuffer.allocate(16);
        bytes.putLong(uuid.getMostSignificantBits());
        bytes.putLong(uuid.getLeastSignificantBits());
        bytes.position(0);
        return bytes;
    }
}

