/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.utils;

import com.facebook.airlift.units.Duration;
import com.facebook.drift.codec.CodecThriftType;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.coercion.FromThrift;
import com.facebook.drift.codec.internal.coercion.ToThrift;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import jakarta.inject.Inject;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DurationToMillisThriftCodec
implements ThriftCodec<Duration> {
    private static final ThriftType THRIFT_TYPE = new ThriftType(ThriftType.DOUBLE, Duration.class);

    @Inject
    public DurationToMillisThriftCodec(ThriftCatalog thriftCatalog) {
        thriftCatalog.addDefaultCoercions(this.getClass());
    }

    @CodecThriftType
    public static ThriftType getThriftType() {
        return THRIFT_TYPE;
    }

    public ThriftType getType() {
        return THRIFT_TYPE;
    }

    public Duration read(TProtocolReader protocol) throws Exception {
        return DurationToMillisThriftCodec.millisToDuration(protocol.readDouble());
    }

    public void write(Duration duration, TProtocolWriter protocol) throws Exception {
        protocol.writeDouble(DurationToMillisThriftCodec.durationToMillis(duration));
    }

    @FromThrift
    public static Duration millisToDuration(double millis) {
        return new Duration(millis, TimeUnit.MILLISECONDS);
    }

    @ToThrift
    public static double durationToMillis(Duration duration) {
        Objects.requireNonNull(duration, "duration is null");
        return duration.getValue(TimeUnit.MILLISECONDS);
    }
}

