/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.idl.generator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ThriftIdlGeneratorConfig {
    private final String defaultPackage;
    private final Map<String, String> namespaces;
    private final Map<String, String> includes;
    private final boolean recursive;
    private final Consumer<String> errorLogger;
    private final Consumer<String> warningLogger;
    private final Consumer<String> verboseLogger;
    private final List<String> customCodecs;

    private ThriftIdlGeneratorConfig(String defaultPackage, Map<String, String> namespaces, Map<String, String> includes, boolean recursive, Consumer<String> errorLogger, Consumer<String> warningLogger, Consumer<String> verboseLogger, List<String> customCodecs) {
        this.defaultPackage = (String)MoreObjects.firstNonNull((Object)defaultPackage, (Object)"");
        this.namespaces = ImmutableMap.copyOf((Map)((Map)MoreObjects.firstNonNull(namespaces, (Object)ImmutableMap.of())));
        this.includes = ImmutableMap.copyOf((Map)((Map)MoreObjects.firstNonNull(includes, (Object)ImmutableMap.of())));
        this.recursive = recursive;
        this.errorLogger = (Consumer)MoreObjects.firstNonNull(errorLogger, ignored -> {});
        this.warningLogger = (Consumer)MoreObjects.firstNonNull(warningLogger, ignored -> {});
        this.verboseLogger = (Consumer)MoreObjects.firstNonNull(verboseLogger, ignored -> {});
        this.customCodecs = ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull(customCodecs, (Object)ImmutableList.of())));
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Map<String, String> getIncludes() {
        return this.includes;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public Consumer<String> getErrorLogger() {
        return this.errorLogger;
    }

    public Consumer<String> getWarningLogger() {
        return this.warningLogger;
    }

    public Consumer<String> getVerboseLogger() {
        return this.verboseLogger;
    }

    public List<String> getCustomCodecs() {
        return this.customCodecs;
    }

    public static class Builder {
        private String defaultPackage;
        private Map<String, String> namespaces;
        private Map<String, String> includes;
        private boolean recursive;
        private Consumer<String> errorLogger;
        private Consumer<String> warningLogger;
        private Consumer<String> verboseLogger;
        private List<String> customCodecs;

        private Builder() {
        }

        public Builder defaultPackage(String defaultPackage) {
            this.defaultPackage = defaultPackage;
            return this;
        }

        public Builder namespaces(Map<String, String> namespaces) {
            this.namespaces = ImmutableMap.copyOf((Map)((Map)MoreObjects.firstNonNull(namespaces, (Object)ImmutableMap.of())));
            return this;
        }

        public Builder includes(Map<String, String> includes) {
            this.includes = ImmutableMap.copyOf((Map)((Map)MoreObjects.firstNonNull(includes, (Object)ImmutableMap.of())));
            return this;
        }

        public Builder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Builder errorLogger(Consumer<String> errorLogger) {
            this.errorLogger = errorLogger;
            return this;
        }

        public Builder warningLogger(Consumer<String> warningLogger) {
            this.warningLogger = warningLogger;
            return this;
        }

        public Builder verboseLogger(Consumer<String> verboseLogger) {
            this.verboseLogger = verboseLogger;
            return this;
        }

        public Builder customCodecs(List<String> customCodecs) {
            this.customCodecs = ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull(customCodecs, (Object)ImmutableList.of())));
            return this;
        }

        public ThriftIdlGeneratorConfig build() {
            return new ThriftIdlGeneratorConfig(this.defaultPackage, this.namespaces, this.includes, this.recursive, this.errorLogger, this.warningLogger, this.verboseLogger, this.customCodecs);
        }
    }
}

