/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.idl.generator;

import com.facebook.drift.codec.metadata.ReflectionHelper;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftType;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public class ThriftTypeRenderer {
    private final Map<ThriftType, String> typeNames;
    private final ThriftCatalog catalog;

    public ThriftTypeRenderer(Map<ThriftType, String> typeNames, ThriftCatalog catalog) {
        this.typeNames = ImmutableMap.copyOf(typeNames);
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
    }

    public String toString(ThriftType type) {
        if (ReflectionHelper.isOptional((Type)type.getJavaType())) {
            Type unwrappedJavaType = ReflectionHelper.getOptionalType((Type)type.getJavaType());
            ThriftType thriftType = this.catalog.getThriftType(unwrappedJavaType);
            return this.toString(thriftType);
        }
        switch (type.getProtocolType()) {
            case BOOL: {
                return "bool";
            }
            case BYTE: {
                return "byte";
            }
            case DOUBLE: {
                return "double";
            }
            case I16: {
                return "i16";
            }
            case I32: {
                return "i32";
            }
            case I64: {
                return "i64";
            }
            case ENUM: {
                return this.prefix(type) + type.getEnumMetadata().getEnumName();
            }
            case MAP: {
                return String.format("map<%s, %s>", this.toString(type.getKeyTypeReference().get()), this.toString(type.getValueTypeReference().get()));
            }
            case SET: {
                return String.format("set<%s>", this.toString(type.getValueTypeReference().get()));
            }
            case LIST: {
                return String.format("list<%s>", this.toString(type.getValueTypeReference().get()));
            }
            case STRUCT: {
                return type.equals((Object)ThriftType.VOID) ? "void" : this.prefix(type) + type.getStructMetadata().getStructName();
            }
            case STRING: {
                return "string";
            }
            case BINARY: {
                return "binary";
            }
        }
        throw new IllegalStateException("Bad protocol type: " + type.getProtocolType());
    }

    private String prefix(ThriftType type) {
        String result = this.typeNames.get(type);
        return result == null ? "" : result + ".";
    }
}

