/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.server;

import com.facebook.drift.server.MethodInvocationFilter;
import com.facebook.drift.server.ServerMethodInvoker;
import com.facebook.drift.transport.server.ServerInvokeRequest;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

class FilteredMethodInvoker
implements ServerMethodInvoker {
    private final MethodInvocationFilter filter;
    private final ServerMethodInvoker next;

    public static ServerMethodInvoker createFilteredMethodInvoker(List<MethodInvocationFilter> filters, ServerMethodInvoker methodInvoker) {
        for (MethodInvocationFilter filter : Lists.reverse(filters)) {
            methodInvoker = new FilteredMethodInvoker(filter, methodInvoker);
        }
        return methodInvoker;
    }

    private FilteredMethodInvoker(MethodInvocationFilter filter, ServerMethodInvoker next) {
        this.filter = filter;
        this.next = next;
    }

    @Override
    public ListenableFuture<Object> invoke(ServerInvokeRequest request) {
        return this.filter.invoke(request, this.next);
    }
}

