/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.server;

import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.server.DriftServerMethodInvoker;
import com.facebook.drift.server.DriftService;
import com.facebook.drift.server.MethodInvocationFilter;
import com.facebook.drift.server.stats.MethodInvocationStatsFactory;
import com.facebook.drift.transport.server.ServerMethodInvoker;
import com.facebook.drift.transport.server.ServerTransport;
import com.facebook.drift.transport.server.ServerTransportFactory;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DriftServer {
    private final ServerTransport serverTransport;

    @Inject
    public DriftServer(ServerTransportFactory serverTransportFactory, ThriftCodecManager codecManager, MethodInvocationStatsFactory methodInvocationStatsFactory, Set<DriftService> services, Set<MethodInvocationFilter> filters) {
        Objects.requireNonNull(serverTransportFactory, "serverTransportFactory is null");
        Objects.requireNonNull(codecManager, "codecManager is null");
        Objects.requireNonNull(services, "services is null");
        DriftServerMethodInvoker methodInvoker = new DriftServerMethodInvoker(codecManager, services, (List<MethodInvocationFilter>)ImmutableList.copyOf(filters), methodInvocationStatsFactory);
        this.serverTransport = serverTransportFactory.createServerTransport((ServerMethodInvoker)methodInvoker);
    }

    public ServerTransport getServerTransport() {
        return this.serverTransport;
    }

    @PostConstruct
    public void start() {
        this.serverTransport.start();
    }

    @PreDestroy
    public void shutdown() {
        this.serverTransport.shutdown();
    }
}

