/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.server.stats;

import com.facebook.drift.codec.metadata.ThriftServiceMetadata;
import com.facebook.drift.server.stats.JmxMethodInvocationStat;
import com.facebook.drift.server.stats.MethodInvocationStat;
import com.facebook.drift.server.stats.MethodInvocationStatsFactory;
import com.facebook.drift.transport.MethodMetadata;
import jakarta.inject.Inject;
import java.io.Closeable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNameBuilder;

public class JmxMethodInvocationStatsFactory
implements Closeable,
MethodInvocationStatsFactory {
    private final MBeanExporter exporter;
    private final Map<String, MethodInvocationStat> stats = new ConcurrentHashMap<String, MethodInvocationStat>();

    @Inject
    public JmxMethodInvocationStatsFactory(MBeanExporter exporter) {
        this.exporter = Objects.requireNonNull(exporter, "exporter is null");
    }

    @Override
    public synchronized MethodInvocationStat getStat(ThriftServiceMetadata serviceMetadata, Optional<String> qualifier, MethodMetadata metadata) {
        ObjectNameBuilder objectNameBuilder = new ObjectNameBuilder("thrift.server");
        objectNameBuilder.withProperty("name", serviceMetadata.getName());
        qualifier.ifPresent(qualifierName -> objectNameBuilder.withProperty("type", qualifierName));
        objectNameBuilder.withProperty("method", metadata.getName());
        String objectName = objectNameBuilder.build();
        return this.stats.computeIfAbsent(objectName, name -> {
            JmxMethodInvocationStat stat = new JmxMethodInvocationStat(metadata.getName());
            this.exporter.export(objectName, (Object)stat);
            return stat;
        });
    }

    @Override
    public synchronized void close() {
        for (String name : this.stats.keySet()) {
            this.exporter.unexport(name);
        }
        this.stats.clear();
    }
}

