/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.units.Duration;
import com.facebook.drift.transport.client.InvokeRequest;
import com.facebook.drift.transport.client.MethodInvoker;
import com.facebook.drift.transport.client.RequestTimeoutException;
import com.facebook.drift.transport.netty.client.ConnectionManager;
import com.facebook.drift.transport.netty.client.InvocationResponseFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class DriftNettyMethodInvoker
implements MethodInvoker {
    private static final Logger log = Logger.get(DriftNettyMethodInvoker.class);
    private static final Duration DEFAULT_INVOCATION_TIMEOUT_GRACE_PERIOD = new Duration(10.0, TimeUnit.SECONDS);
    private final ConnectionManager.ConnectionParameters connectionParameters;
    private final ConnectionManager connectionManager;
    private final ListeningScheduledExecutorService delayService;
    private final Duration invokeTimeout;

    public DriftNettyMethodInvoker(ConnectionManager.ConnectionParameters connectionParameters, ConnectionManager connectionManager, ScheduledExecutorService delayService) {
        this(connectionParameters, connectionManager, delayService, DEFAULT_INVOCATION_TIMEOUT_GRACE_PERIOD);
    }

    @VisibleForTesting
    DriftNettyMethodInvoker(ConnectionManager.ConnectionParameters connectionParameters, ConnectionManager connectionManager, ScheduledExecutorService delayService, Duration invocationTimeoutGracePeriod) {
        this.connectionParameters = Objects.requireNonNull(connectionParameters, "connectionConfig is null");
        this.connectionManager = Objects.requireNonNull(connectionManager, "connectionManager is null");
        this.delayService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Objects.requireNonNull(delayService, "delayService is null"));
        this.invokeTimeout = new Duration((double)(invocationTimeoutGracePeriod.toMillis() + connectionParameters.getConnectTimeout().toMillis() + connectionParameters.getRequestTimeout().toMillis()), TimeUnit.MILLISECONDS);
    }

    public ListenableFuture<Object> invoke(InvokeRequest request) {
        try {
            return MoreFutures.addTimeout((ListenableFuture)InvocationResponseFuture.createInvocationResponseFuture(request, this.connectionParameters, this.connectionManager), () -> {
                String message = "Invocation response future did not complete after " + this.invokeTimeout;
                log.error(message);
                throw new RequestTimeoutException(message);
            }, (Duration)this.invokeTimeout, (ScheduledExecutorService)this.delayService);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public ListenableFuture<?> delay(Duration duration) {
        return this.delayService.schedule(() -> null, duration.toMillis(), TimeUnit.MILLISECONDS);
    }
}

