/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.units.Duration;
import com.facebook.drift.transport.client.MethodInvoker;
import com.facebook.drift.transport.client.MethodInvokerFactory;
import com.facebook.drift.transport.netty.client.ConnectionFactory;
import com.facebook.drift.transport.netty.client.ConnectionManager;
import com.facebook.drift.transport.netty.client.ConnectionPool;
import com.facebook.drift.transport.netty.client.DriftNettyClientConfig;
import com.facebook.drift.transport.netty.client.DriftNettyConnectionFactoryConfig;
import com.facebook.drift.transport.netty.client.DriftNettyMethodInvoker;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.Transport;
import com.facebook.drift.transport.netty.ssl.SslContextFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import jakarta.annotation.PreDestroy;
import java.io.Closeable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class DriftNettyMethodInvokerFactory<I>
implements MethodInvokerFactory<I>,
Closeable {
    private final Function<I, DriftNettyClientConfig> clientConfigurationProvider;
    private final EventLoopGroup group;
    private final SslContextFactory sslContextFactory;
    private final Optional<HostAndPort> defaultSocksProxy;
    private final ConnectionFactory connectionFactory;
    private final ScheduledExecutorService connectionPoolMaintenanceExecutor;
    private final DriftNettyConnectionFactoryConfig factoryConfig;
    private final Map<Optional<I>, ConnectionPool> connectionPools = new ConcurrentHashMap<Optional<I>, ConnectionPool>();
    private final Function<EventExecutorGroup, Future<?>> shutdownProcedure;

    @VisibleForTesting
    public static DriftNettyMethodInvokerFactory<?> createStaticDriftNettyMethodInvokerFactory(DriftNettyClientConfig clientConfig, ByteBufAllocator allocator) {
        return new DriftNettyMethodInvokerFactory<Object>(new DriftNettyConnectionFactoryConfig(), clientIdentity -> clientConfig, allocator, x -> x.shutdownGracefully(0L, 1L, TimeUnit.SECONDS));
    }

    public DriftNettyMethodInvokerFactory(DriftNettyConnectionFactoryConfig factoryConfig, Function<I, DriftNettyClientConfig> clientConfigurationProvider) {
        this(factoryConfig, clientConfigurationProvider, ByteBufAllocator.DEFAULT, EventExecutorGroup::shutdownGracefully);
    }

    @VisibleForTesting
    public DriftNettyMethodInvokerFactory(DriftNettyConnectionFactoryConfig factoryConfig, Function<I, DriftNettyClientConfig> clientConfigurationProvider, ByteBufAllocator allocator, Function<EventExecutorGroup, Future<?>> shutdownProcedure) {
        this.factoryConfig = Objects.requireNonNull(factoryConfig, "factoryConfig is null");
        if (factoryConfig.isNativeTransportEnabled()) {
            Preconditions.checkState((boolean)Epoll.isAvailable(), (Object)"native transport is not available");
            this.group = new EpollEventLoopGroup(factoryConfig.getThreadCount(), Threads.daemonThreadsNamed((String)"drift-client-%s"));
        } else {
            this.group = new NioEventLoopGroup(factoryConfig.getThreadCount(), Threads.daemonThreadsNamed((String)"drift-client-%s"));
        }
        this.clientConfigurationProvider = Objects.requireNonNull(clientConfigurationProvider, "clientConfigurationProvider is null");
        this.sslContextFactory = SslContextFactory.createSslContextFactory(true, factoryConfig.getSslContextRefreshTime(), (ScheduledExecutorService)this.group);
        this.defaultSocksProxy = Optional.ofNullable(factoryConfig.getSocksProxy());
        this.shutdownProcedure = Objects.requireNonNull(shutdownProcedure, "shutdownProcedure is null");
        this.connectionPoolMaintenanceExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"drift-connection-maintenance"));
        this.connectionFactory = new ConnectionFactory(this.group, this.sslContextFactory, allocator, factoryConfig);
    }

    public MethodInvoker createMethodInvoker(I clientIdentity) {
        DriftNettyClientConfig driftNettyClientConfig = this.clientConfigurationProvider.apply(clientIdentity);
        ConnectionManager.ConnectionParameters clientConfig = this.toConnectionConfig(driftNettyClientConfig);
        clientConfig.getSslContextParameters().ifPresent(sslContextParameters -> this.sslContextFactory.get((SslContextFactory.SslContextParameters)sslContextParameters).get());
        ConnectionManager connectionManager = this.getConnectionManager(clientIdentity, driftNettyClientConfig);
        return new DriftNettyMethodInvoker(clientConfig, connectionManager, (ScheduledExecutorService)this.group);
    }

    public ConnectionManager getConnectionManager(I clientIdentity, DriftNettyClientConfig driftNettyClientConfig) {
        boolean connectionPoolEnabled = (Boolean)MoreObjects.firstNonNull((Object)driftNettyClientConfig.getConnectionPoolEnabled(), (Object)this.factoryConfig.isConnectionPoolEnabled());
        if (!connectionPoolEnabled) {
            return this.connectionFactory;
        }
        int connectionPoolMaxSize = (Integer)MoreObjects.firstNonNull((Object)driftNettyClientConfig.getConnectionPoolMaxSize(), (Object)this.factoryConfig.getConnectionPoolMaxSize());
        int maxConnectionsPerDestination = (Integer)MoreObjects.firstNonNull((Object)driftNettyClientConfig.getConnectionPoolMaxConnectionsPerDestination(), (Object)this.factoryConfig.getConnectionPoolMaxConnectionsPerDestination());
        Duration connectionPoolIdleTimeout = (Duration)MoreObjects.firstNonNull((Object)driftNettyClientConfig.getConnectionPoolIdleTimeout(), (Object)this.factoryConfig.getConnectionPoolIdleTimeout());
        return this.connectionPools.computeIfAbsent(Optional.ofNullable(clientIdentity), ignored -> new ConnectionPool(this.connectionFactory, this.group, connectionPoolMaxSize, maxConnectionsPerDestination, connectionPoolIdleTimeout, this.connectionPoolMaintenanceExecutor));
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            this.connectionPools.values().forEach(ConnectionPool::close);
            this.connectionFactory.close();
        }
        finally {
            this.connectionPoolMaintenanceExecutor.shutdownNow();
            try {
                this.shutdownProcedure.apply((EventExecutorGroup)this.group).await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ConnectionManager.ConnectionParameters toConnectionConfig(DriftNettyClientConfig clientConfig) {
        Optional<HostAndPort> socksProxy;
        if (clientConfig.getTransport() == Transport.HEADER && clientConfig.getProtocol() == Protocol.COMPACT) {
            throw new IllegalArgumentException("HEADER transport cannot be used with COMPACT protocol, use FB_COMPACT instead");
        }
        Optional<SslContextFactory.SslContextParameters> sslContextConfig = Optional.empty();
        if (clientConfig.isSslEnabled()) {
            sslContextConfig = Optional.of(new SslContextFactory.SslContextParameters(clientConfig.getTrustCertificate(), Optional.ofNullable(clientConfig.getKey()), Optional.ofNullable(clientConfig.getKey()), Optional.ofNullable(clientConfig.getKeyPassword()), clientConfig.getSessionCacheSize(), clientConfig.getSessionTimeout(), clientConfig.getCiphers()));
        }
        if (!(socksProxy = Optional.ofNullable(clientConfig.getSocksProxy())).isPresent()) {
            socksProxy = this.defaultSocksProxy;
        }
        return new ConnectionManager.ConnectionParameters(clientConfig.getTransport(), clientConfig.getProtocol(), clientConfig.getMaxFrameSize(), clientConfig.getConnectTimeout(), clientConfig.getRequestTimeout(), socksProxy, sslContextConfig, clientConfig.isTcpNoDelayEnabled(), clientConfig.isReuseAddressEnabled());
    }
}

