/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.airlift.units.DataSize;
import com.facebook.airlift.units.Duration;
import com.facebook.drift.transport.netty.client.ThriftClientHandler;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.Transport;
import com.google.common.net.HostAndPort;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.function.Supplier;

class ThriftClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final Transport transport;
    private final Protocol protocol;
    private final DataSize maxFrameSize;
    private final Duration requestTimeout;
    private final Optional<HostAndPort> socksProxyAddress;
    private final Optional<Supplier<SslContext>> sslContextSupplier;

    public ThriftClientInitializer(Transport transport, Protocol protocol, DataSize maxFrameSize, Duration requestTimeout, Optional<HostAndPort> socksProxyAddress, Optional<Supplier<SslContext>> sslContextSupplier) {
        this.transport = transport;
        this.protocol = protocol;
        this.maxFrameSize = maxFrameSize;
        this.requestTimeout = requestTimeout;
        this.socksProxyAddress = socksProxyAddress;
        this.sslContextSupplier = sslContextSupplier;
    }

    protected void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        this.socksProxyAddress.ifPresent(socks -> pipeline.addLast(new ChannelHandler[]{new Socks4ProxyHandler((SocketAddress)new InetSocketAddress(socks.getHost(), socks.getPort()))}));
        this.sslContextSupplier.ifPresent(sslContext -> pipeline.addLast(new ChannelHandler[]{((SslContext)sslContext.get()).newHandler(channel.alloc())}));
        this.transport.addFrameHandlers(pipeline, Optional.of(this.protocol), this.maxFrameSize, true);
        pipeline.addLast(new ChannelHandler[]{new ThriftClientHandler(this.requestTimeout, this.transport, this.protocol)});
    }
}

