/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.codec;

import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.ThriftHeaderTransform;
import com.facebook.drift.transport.netty.codec.Transport;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ThriftFrame
implements ReferenceCounted {
    private final int sequenceId;
    private final ByteBuf message;
    private final Map<String, String> headers;
    private final List<ThriftHeaderTransform> transforms;
    private final Transport transport;
    private final Protocol protocol;
    private final boolean supportOutOfOrderResponse;

    public ThriftFrame(int sequenceId, ByteBuf message, Map<String, String> headers, List<ThriftHeaderTransform> transforms, Transport transport, Protocol protocol, boolean supportOutOfOrderResponse) {
        this.sequenceId = sequenceId;
        this.message = Objects.requireNonNull(message, "message is null");
        this.headers = Objects.requireNonNull(headers, "headers is null");
        this.transforms = ImmutableList.copyOf((Collection)Objects.requireNonNull(transforms, "transform is null"));
        this.transport = Objects.requireNonNull(transport, "transport is null");
        this.protocol = Objects.requireNonNull(protocol, "protocol is null");
        this.supportOutOfOrderResponse = supportOutOfOrderResponse;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public ByteBuf getMessage() {
        return this.message.retainedDuplicate();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<ThriftHeaderTransform> getTransforms() {
        return this.transforms;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public boolean isSupportOutOfOrderResponse() {
        return this.supportOutOfOrderResponse;
    }

    public int refCnt() {
        return this.message.refCnt();
    }

    public ThriftFrame retain() {
        this.message.retain();
        return this;
    }

    public ThriftFrame retain(int increment) {
        this.message.retain(increment);
        return this;
    }

    public ThriftFrame touch() {
        this.message.touch();
        return this;
    }

    public ThriftFrame touch(Object hint) {
        this.message.touch(hint);
        return this;
    }

    @CheckReturnValue
    public boolean release() {
        return this.message.release();
    }

    public boolean release(int decrement) {
        return this.message.release(decrement);
    }
}

