/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.codec;

import com.facebook.airlift.units.DataSize;
import com.facebook.drift.protocol.TMessage;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolUtil;
import com.facebook.drift.transport.netty.codec.FrameInfo;
import com.facebook.drift.transport.netty.codec.FrameTooLargeException;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.Transport;
import com.facebook.drift.transport.netty.ssl.TChannelBufferInputTransport;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class ThriftUnframedDecoder
extends ByteToMessageDecoder {
    private final Protocol protocol;
    private final int maxFrameSize;
    private final boolean assumeClientsSupportOutOfOrderResponses;

    public ThriftUnframedDecoder(Protocol protocol, DataSize maxFrameSize, boolean assumeClientsSupportOutOfOrderResponses) {
        this.protocol = Objects.requireNonNull(protocol, "protocol is null");
        this.maxFrameSize = Math.toIntExact(Objects.requireNonNull(maxFrameSize, "maxFrameSize is null").toBytes());
        this.assumeClientsSupportOutOfOrderResponses = assumeClientsSupportOutOfOrderResponses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) {
        int frameOffset = buffer.readerIndex();
        TChannelBufferInputTransport transport = new TChannelBufferInputTransport(buffer.retain());
        try {
            TProtocol protocolReader = this.protocol.createProtocol(transport);
            TMessage message = protocolReader.readMessageBegin();
            TProtocolUtil.skip((TProtocolReader)protocolReader, (byte)12);
            protocolReader.readMessageEnd();
            int frameLength = buffer.readerIndex() - frameOffset;
            if (frameLength > this.maxFrameSize) {
                FrameInfo frameInfo = new FrameInfo(message.getName(), message.getType(), message.getSequenceId(), Transport.UNFRAMED, this.protocol, this.assumeClientsSupportOutOfOrderResponses);
                ctx.fireExceptionCaught((Throwable)((Object)new FrameTooLargeException(Optional.of(frameInfo), frameLength, this.maxFrameSize)));
            }
            out.add(buffer.slice(frameOffset, frameLength).retain());
        }
        catch (Throwable th) {
            buffer.readerIndex(frameOffset);
        }
        finally {
            transport.release();
        }
    }
}

