/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.server;

import com.facebook.airlift.units.DataSize;
import com.facebook.airlift.units.Duration;
import com.facebook.drift.transport.netty.server.OptionalSslHandler;
import com.facebook.drift.transport.netty.server.ThriftProtocolDetection;
import com.facebook.drift.transport.netty.server.ThriftServerHandler;
import com.facebook.drift.transport.server.ServerMethodInvoker;
import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public class ThriftServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final ServerMethodInvoker methodInvoker;
    private final DataSize maxFrameSize;
    private final Duration requestTimeout;
    private final Optional<Supplier<SslContext>> sslContextSupplier;
    private final boolean allowPlainText;
    private final boolean assumeClientsSupportOutOfOrderResponses;
    private final ScheduledExecutorService timeoutExecutor;

    public ThriftServerInitializer(ServerMethodInvoker methodInvoker, DataSize maxFrameSize, Duration requestTimeout, Optional<Supplier<SslContext>> sslContextSupplier, boolean allowPlainText, boolean assumeClientsSupportOutOfOrderResponses, ScheduledExecutorService timeoutExecutor) {
        Objects.requireNonNull(methodInvoker, "methodInvoker is null");
        Objects.requireNonNull(maxFrameSize, "maxFrameSize is null");
        Objects.requireNonNull(requestTimeout, "requestTimeout is null");
        Objects.requireNonNull(sslContextSupplier, "sslContextSupplier is null");
        Preconditions.checkArgument((allowPlainText || sslContextSupplier.isPresent() ? 1 : 0) != 0, (Object)"Plain text is not allowed, but SSL is not configured");
        Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        this.methodInvoker = methodInvoker;
        this.maxFrameSize = maxFrameSize;
        this.requestTimeout = requestTimeout;
        this.sslContextSupplier = sslContextSupplier;
        this.allowPlainText = allowPlainText;
        this.assumeClientsSupportOutOfOrderResponses = assumeClientsSupportOutOfOrderResponses;
        this.timeoutExecutor = timeoutExecutor;
    }

    protected void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.sslContextSupplier.isPresent()) {
            if (this.allowPlainText) {
                pipeline.addLast(new ChannelHandler[]{new OptionalSslHandler(this.sslContextSupplier.get().get())});
            } else {
                pipeline.addLast(new ChannelHandler[]{this.sslContextSupplier.get().get().newHandler(channel.alloc())});
            }
        }
        pipeline.addLast(new ChannelHandler[]{new ThriftProtocolDetection(new ThriftServerHandler(this.methodInvoker, this.requestTimeout, this.timeoutExecutor), this.maxFrameSize, this.assumeClientsSupportOutOfOrderResponses)});
    }
}

