/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.ssl;

import com.facebook.airlift.concurrent.NotThreadSafe;
import com.facebook.drift.protocol.TTransport;
import com.google.errorprone.annotations.CheckReturnValue;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import java.util.Objects;

@NotThreadSafe
public class TChannelBufferInputTransport
implements TTransport,
ReferenceCounted {
    private final ByteBuf buffer;

    public TChannelBufferInputTransport(ByteBuf buffer) {
        this.buffer = Objects.requireNonNull(buffer, "buffer is null");
    }

    public void read(byte[] buf, int off, int len) {
        this.buffer.readBytes(buf, off, len);
    }

    public void write(byte[] buf, int off, int len) {
        throw new UnsupportedOperationException();
    }

    public int refCnt() {
        return this.buffer.refCnt();
    }

    public ReferenceCounted retain() {
        this.buffer.retain();
        return this;
    }

    public ReferenceCounted retain(int increment) {
        this.buffer.retain(increment);
        return this;
    }

    public ReferenceCounted touch() {
        this.buffer.touch();
        return this;
    }

    public ReferenceCounted touch(Object hint) {
        this.buffer.touch(hint);
        return this;
    }

    @CheckReturnValue
    public boolean release() {
        return this.buffer.release();
    }

    public boolean release(int decrement) {
        return this.buffer.release(decrement);
    }
}

