/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.event.client;

import com.facebook.airlift.event.client.DummyEventClass;
import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.event.client.InMemoryEventClient;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public abstract class AbstractTestMultiEventClient {
    private final DummyEventClass event1 = new DummyEventClass(1.234, 5678, "foo", true);
    private final DummyEventClass event2 = new DummyEventClass(0.001, 1, "bar", false);
    private final DummyEventClass event3 = new DummyEventClass(0.001, 5678, "foo", false);
    protected InMemoryEventClient memoryEventClient1;
    protected InMemoryEventClient memoryEventClient2;
    protected EventClient eventClient;

    @Test
    public void testPostSingleEvent() {
        this.eventClient.post((Object[])new DummyEventClass[]{this.event1});
        Assert.assertEquals((Collection)this.memoryEventClient1.getEvents(), (Collection)ImmutableList.of((Object)this.event1));
        Assert.assertEquals((Collection)this.memoryEventClient2.getEvents(), (Collection)ImmutableList.of((Object)this.event1));
    }

    @Test
    public void testPostMultiple() {
        this.eventClient.post((Object[])new DummyEventClass[]{this.event1});
        this.eventClient.post((Object[])new DummyEventClass[]{this.event2});
        this.eventClient.post((Object[])new DummyEventClass[]{this.event3});
        Assert.assertEquals((Collection)this.memoryEventClient1.getEvents(), (Collection)ImmutableList.of((Object)this.event1, (Object)this.event2, (Object)this.event3));
        Assert.assertEquals((Collection)this.memoryEventClient2.getEvents(), (Collection)ImmutableList.of((Object)this.event1, (Object)this.event2, (Object)this.event3));
    }

    @Test
    public void testPostVarArgs() {
        this.eventClient.post((Object[])new DummyEventClass[]{this.event1, this.event2, this.event3});
        Assert.assertEquals((Collection)this.memoryEventClient1.getEvents(), (Collection)ImmutableList.of((Object)this.event1, (Object)this.event2, (Object)this.event3));
        Assert.assertEquals((Collection)this.memoryEventClient2.getEvents(), (Collection)ImmutableList.of((Object)this.event1, (Object)this.event2, (Object)this.event3));
    }

    @Test
    public void testPostIterable() {
        this.eventClient.post((Iterable)ImmutableList.of((Object)this.event1, (Object)this.event2, (Object)this.event3));
        Assert.assertEquals((Collection)this.memoryEventClient1.getEvents(), (Collection)ImmutableList.of((Object)this.event1, (Object)this.event2, (Object)this.event3));
        Assert.assertEquals((Collection)this.memoryEventClient2.getEvents(), (Collection)ImmutableList.of((Object)this.event1, (Object)this.event2, (Object)this.event3));
    }

    @Test
    public void testPostEventPoster() {
        this.eventClient.post(objectEventPoster -> {
            objectEventPoster.post((Object)this.event1);
            objectEventPoster.post((Object)this.event2);
            objectEventPoster.post((Object)this.event3);
        });
        Assert.assertEquals((Collection)this.memoryEventClient1.getEvents(), (Collection)ImmutableList.of((Object)this.event1, (Object)this.event2, (Object)this.event3));
        Assert.assertEquals((Collection)this.memoryEventClient2.getEvents(), (Collection)ImmutableList.of((Object)this.event1, (Object)this.event2, (Object)this.event3));
    }
}

