/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.event.client;

import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventType;
import com.facebook.airlift.event.client.FixedDummyEventWithZonedDateTimeClass;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@EventType(value="NestedDummy")
public class NestedDummyEventWithZonedDateTimeClass
extends FixedDummyEventWithZonedDateTimeClass {
    private final List<String> strings;
    private final NestedPart nestedPart;
    private final List<NestedPart> nestedParts;

    public NestedDummyEventWithZonedDateTimeClass(String host, ZonedDateTime timestamp, UUID uuid, int intValue, String stringValue, List<String> strings, NestedPart nestedPart, List<NestedPart> nestedParts) {
        super(host, timestamp, uuid, intValue, stringValue);
        this.strings = strings;
        this.nestedPart = nestedPart;
        this.nestedParts = nestedParts;
    }

    @EventField
    public List<String> getStrings() {
        return this.strings;
    }

    @EventField
    public NestedPart getNestedPart() {
        return this.nestedPart;
    }

    @EventField
    public List<NestedPart> getNestedParts() {
        return this.nestedParts;
    }

    @EventField
    public Map<String, String> getNamedStrings() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String s : this.strings) {
            builder.put((Object)s, (Object)s);
        }
        return builder.build();
    }

    @EventField
    public Multimap<String, String> getNamedStringList() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (String s : this.strings) {
            builder.putAll((Object)s, (Object[])new String[]{s, s, s});
        }
        return builder.build();
    }

    @EventField
    public Map<String, NestedPart> getNamedParts() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (NestedPart part : this.nestedParts) {
            builder.put((Object)part.getName(), (Object)part);
        }
        return builder.build();
    }

    @EventType
    public static class NestedPart {
        private final String name;
        private final NestedPart part;

        public NestedPart(String name, NestedPart part) {
            this.name = name;
            this.part = part;
        }

        @EventField
        public String getName() {
            return this.name;
        }

        @EventField
        public NestedPart getPart() {
            return this.part;
        }
    }
}

