/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.event.client;

import com.facebook.airlift.event.client.EventSubmissionFailedException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEventSubmissionFailedException {
    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="causes is null")
    public void testRejectsNull() {
        throw new EventSubmissionFailedException("service", "type", null);
    }

    @Test
    public void testEmptyCause() {
        EventSubmissionFailedException e = new EventSubmissionFailedException("service", "type", Collections.emptyMap());
        Assert.assertNull((Object)e.getCause());
    }

    @Test
    public void testSingleCause() {
        RuntimeException cause = new RuntimeException();
        EventSubmissionFailedException e = new EventSubmissionFailedException("service", "type", (Map)ImmutableMap.of((Object)URI.create("/"), (Object)cause));
        Assert.assertSame((Object)e.getCause(), (Object)cause);
    }

    @Test
    public void testMessageMentionsServiceAndType() {
        EventSubmissionFailedException e = new EventSubmissionFailedException("serviceX", "typeY", Collections.emptyMap());
        Assert.assertTrue((boolean)e.getMessage().contains("serviceX"));
        Assert.assertTrue((boolean)e.getMessage().contains("typeY"));
    }

    @Test
    public void testPicksFirstCause() {
        URI uri1 = URI.create("/y");
        URI uri2 = URI.create("/x");
        RuntimeException cause1 = new RuntimeException("y");
        RuntimeException cause2 = new RuntimeException("x");
        ImmutableSortedMap causes = ImmutableSortedMap.orderedBy((Comparator)Ordering.explicit((Object)uri1, (Object[])new URI[]{uri2})).put((Object)uri1, (Object)cause1).put((Object)uri2, (Object)cause2).build();
        EventSubmissionFailedException e = new EventSubmissionFailedException("service", "type", (Map)causes);
        Assert.assertSame((Object)e.getCause(), (Object)cause1);
    }
}

